package ru.yandex.qe.dispenser.ws.quota.request.workflow.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.api.v1.DiUnit;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.ws.quota.request.workflow.context.RequestContext;

@ParametersAreNonnullByDefault
public class MdbServiceChangesValidatorImpl implements ServiceChangesValidator {
    private final static String MDB_HDD_CLICKHOUSE_RESOURCE_KEY = "hdd_dbaas_clickhouse";
    private final static DiAmount MDB_HDD_MULTIPLICITY_MAGIC_DI_AMOUNT = DiAmount.of(12800L, DiUnit.GIBIBYTE);
    private final static Long MDB_HDD_MULTIPLICITY_MAGIC_NUMBER = DiUnit.BYTE.convert(MDB_HDD_MULTIPLICITY_MAGIC_DI_AMOUNT);

    @Override
    public void validateChanges(final RequestContext context, final List<? extends QuotaChangeRequest.ChangeAmount> changes) {
        changes.stream()
                .filter(e -> MDB_HDD_CLICKHOUSE_RESOURCE_KEY.equals(e.getResource().getKey().getPublicKey()))
                .findFirst()
                .ifPresent(e -> {
                    if (e.getAmount() % MDB_HDD_MULTIPLICITY_MAGIC_NUMBER != 0) {
                        throw new IllegalArgumentException(String.format("HDD Clickhouse should be a multiple of %s",
                                MDB_HDD_MULTIPLICITY_MAGIC_DI_AMOUNT.toString()));
                    }
                });
    }
}
