package ru.yandex.qe.dispenser.ws.quota.request.workflow.service;

import java.util.Map;
import java.util.Set;

public class ServicePreorderRestriction {
    private final Map<Long, Set<String>> locations;
    private final Map<Long, Set<String>> resourceGroups;
    private final Set<Long> bigOrderIds;
    private final Map<Long, Map<String, Set<String>>> groupLocations;

    public ServicePreorderRestriction(final Map<Long, Set<String>> locations,
                                      final Map<Long, Set<String>> resourceGroups,
                                      final Set<Long> bigOrderIds,
                                      final Map<Long, Map<String, Set<String>>> locationResourcePairs) {
        this.locations = locations;
        this.resourceGroups = resourceGroups;
        this.bigOrderIds = bigOrderIds;
        this.groupLocations = locationResourcePairs;
    }

    public Map<Long, Set<String>> getLocations() {
        return locations;
    }

    public Map<Long, Set<String>> getResourceGroups() {
        return resourceGroups;
    }

    public Set<Long> getBigOrderIds() {
        return bigOrderIds;
    }

    public Map<Long, Map<String, Set<String>>> getGroupLocations() {
        return groupLocations;
    }
}
