package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationGroup {

    private final String name;
    private final List<AllocationDestinationSourceResource> resources;
    private final List<AllocationDestinationTargetAccount> targetAccounts;

    @JsonCreator
    public AllocationDestinationGroup(
            @JsonProperty("name") String name,
            @JsonProperty("resources") List<AllocationDestinationSourceResource> resources,
            @JsonProperty("targetAccounts") List<AllocationDestinationTargetAccount> targetAccounts) {
        this.name = name;
        this.resources = resources;
        this.targetAccounts = targetAccounts;
    }

    public String getName() {
        return name;
    }

    public List<AllocationDestinationSourceResource> getResources() {
        return resources;
    }

    public List<AllocationDestinationTargetAccount> getTargetAccounts() {
        return targetAccounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationGroup that = (AllocationDestinationGroup) o;
        return Objects.equals(name, that.name) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(targetAccounts, that.targetAccounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, resources, targetAccounts);
    }

    @Override
    public String toString() {
        return "AllocationDestinationGroup{" +
                "name='" + name + '\'' +
                ", resources=" + resources +
                ", targetAccounts=" + targetAccounts +
                '}';
    }

}
