package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationSelectionQuotaRequest {

    private final long quotaRequestId;
    private final List<String> providerKeys;

    @JsonCreator
    public AllocationDestinationSelectionQuotaRequest(@JsonProperty("quotaRequestId") long quotaRequestId,
                                                      @JsonProperty("providerKeys") List<String> providerKeys) {
        this.quotaRequestId = quotaRequestId;
        this.providerKeys = providerKeys != null ? providerKeys : List.of();
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public List<String> getProviderKeys() {
        return providerKeys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationSelectionQuotaRequest that = (AllocationDestinationSelectionQuotaRequest) o;
        return quotaRequestId == that.quotaRequestId &&
                Objects.equals(providerKeys, that.providerKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, providerKeys);
    }

    @Override
    public String toString() {
        return "AllocationDestinationSelectionQuotaRequest{" +
                "quotaRequestId=" + quotaRequestId +
                ", providerKeys=" + providerKeys +
                '}';
    }

}
