package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationSelectionRequest {

    private final List<AllocationDestinationSelectionQuotaRequest> requests;

    @JsonCreator
    public AllocationDestinationSelectionRequest(
            @JsonProperty("requests") List<AllocationDestinationSelectionQuotaRequest> requests) {
        this.requests = requests != null ? requests : List.of();
    }

    public List<AllocationDestinationSelectionQuotaRequest> getRequests() {
        return requests;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationSelectionRequest that = (AllocationDestinationSelectionRequest) o;
        return Objects.equals(requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requests);
    }

    @Override
    public String toString() {
        return "AllocationDestinationSelectionRequest{" +
                "requests=" + requests +
                '}';
    }

}
