package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationSelectionResponse {

    private final List<AllocationDestinationQuotaRequest> requests;

    @JsonCreator
    public AllocationDestinationSelectionResponse(
            @JsonProperty("requests") List<AllocationDestinationQuotaRequest> requests) {
        this.requests = requests;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<AllocationDestinationQuotaRequest> getRequests() {
        return requests;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationSelectionResponse that = (AllocationDestinationSelectionResponse) o;
        return Objects.equals(requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requests);
    }

    @Override
    public String toString() {
        return "AllocationDestinationSelectionResponse{" +
                "requests=" + requests +
                '}';
    }

    public static final class Builder {

        private final List<AllocationDestinationQuotaRequest> requests = new ArrayList<>();

        private Builder() {
        }

        public Builder addRequest(AllocationDestinationQuotaRequest request) {
            this.requests.add(request);
            return this;
        }

        public AllocationDestinationSelectionResponse build() {
            return new AllocationDestinationSelectionResponse(requests);
        }

    }

}
