package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationSourceResource {

    private final String resourceKey;
    private final String resourceName;
    private final List<AllocationDestinationSourceResourceSegment> segments;
    private final List<AllocationDestinationTargetResource> targetResources;

    @JsonCreator
    public AllocationDestinationSourceResource(
            @JsonProperty("resourceKey") String resourceKey,
            @JsonProperty("resourceName") String resourceName,
            @JsonProperty("segments") List<AllocationDestinationSourceResourceSegment> segments,
            @JsonProperty("targetResources") List<AllocationDestinationTargetResource> targetResources) {
        this.resourceKey = resourceKey;
        this.resourceName = resourceName;
        this.segments = segments;
        this.targetResources = targetResources;
    }

    public String getResourceKey() {
        return resourceKey;
    }

    public String getResourceName() {
        return resourceName;
    }

    public List<AllocationDestinationSourceResourceSegment> getSegments() {
        return segments;
    }

    public List<AllocationDestinationTargetResource> getTargetResources() {
        return targetResources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationSourceResource that = (AllocationDestinationSourceResource) o;
        return Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(resourceName, that.resourceName) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(targetResources, that.targetResources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceKey, resourceName, segments, targetResources);
    }

    @Override
    public String toString() {
        return "AllocationDestinationSourceResource{" +
                "resourceKey='" + resourceKey + '\'' +
                ", resourceName='" + resourceName + '\'' +
                ", segments=" + segments +
                ", targetResources=" + targetResources +
                '}';
    }

}
