package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationSourceResourceSegment {

    private final String segmentationKey;
    private final String segmentationName;
    private final String segmentKey;
    private final String segmentName;

    @JsonCreator
    public AllocationDestinationSourceResourceSegment(@JsonProperty("segmentationKey") String segmentationKey,
                                                      @JsonProperty("segmentationName") String segmentationName,
                                                      @JsonProperty("segmentKey") String segmentKey,
                                                      @JsonProperty("segmentName") String segmentName) {
        this.segmentationKey = segmentationKey;
        this.segmentationName = segmentationName;
        this.segmentKey = segmentKey;
        this.segmentName = segmentName;
    }

    public String getSegmentationKey() {
        return segmentationKey;
    }

    public String getSegmentationName() {
        return segmentationName;
    }

    public String getSegmentKey() {
        return segmentKey;
    }

    public String getSegmentName() {
        return segmentName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationSourceResourceSegment that = (AllocationDestinationSourceResourceSegment) o;
        return Objects.equals(segmentationKey, that.segmentationKey) &&
                Objects.equals(segmentationName, that.segmentationName) &&
                Objects.equals(segmentKey, that.segmentKey) &&
                Objects.equals(segmentName, that.segmentName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationKey, segmentationName, segmentKey, segmentName);
    }

    @Override
    public String toString() {
        return "AllocationDestinationSourceResourceSegment{" +
                "segmentationKey='" + segmentationKey + '\'' +
                ", segmentationName='" + segmentationName + '\'' +
                ", segmentKey='" + segmentKey + '\'' +
                ", segmentName='" + segmentName + '\'' +
                '}';
    }

}
