package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationTargetAccount {

    private final String id;
    private final String name;
    private final String folderId;
    private final String folderName;
    private final String providerId;
    private final String providerName;
    private final String accountsSpaceId;
    private final String accountsSpaceName;

    @JsonCreator
    public AllocationDestinationTargetAccount(@JsonProperty("id") String id,
                                              @JsonProperty("name") String name,
                                              @JsonProperty("folderId") String folderId,
                                              @JsonProperty("folderName") String folderName,
                                              @JsonProperty("providerId") String providerId,
                                              @JsonProperty("providerName") String providerName,
                                              @JsonProperty("accountsSpaceId") String accountsSpaceId,
                                              @JsonProperty("accountsSpaceName") String accountsSpaceName) {
        this.id = id;
        this.name = name;
        this.folderId = folderId;
        this.folderName = folderName;
        this.providerId = providerId;
        this.providerName = providerName;
        this.accountsSpaceId = accountsSpaceId;
        this.accountsSpaceName = accountsSpaceName;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getFolderId() {
        return folderId;
    }

    public String getFolderName() {
        return folderName;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getProviderName() {
        return providerName;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getAccountsSpaceName() {
        return Optional.ofNullable(accountsSpaceName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationTargetAccount that = (AllocationDestinationTargetAccount) o;
        return Objects.equals(id, that.id) && Objects.equals(name, that.name) && Objects.equals(folderId,
                that.folderId) && Objects.equals(folderName, that.folderName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, folderId, folderName);
    }

    @Override
    public String toString() {
        return "AllocationDestinationTargetAccount{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", folderId='" + folderId + '\'' +
                ", folderName='" + folderName + '\'' +
                '}';
    }

}
