package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AllocationDestinationTargetResource {

    private final String resourceId;
    private final String resourceName;
    private final boolean eligible;
    private final List<String> ineligibilityReasons;

    @JsonCreator
    public AllocationDestinationTargetResource(
            @JsonProperty("resourceId") String resourceId,
            @JsonProperty("resourceName") String resourceName,
            @JsonProperty("eligible") boolean eligible,
            @JsonProperty("ineligibilityReasons") List<String> ineligibilityReasons) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.eligible = eligible;
        this.ineligibilityReasons = ineligibilityReasons != null ? ineligibilityReasons : List.of();
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getResourceName() {
        return resourceName;
    }

    public boolean isEligible() {
        return eligible;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public List<String> getIneligibilityReasons() {
        return ineligibilityReasons;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AllocationDestinationTargetResource that = (AllocationDestinationTargetResource) o;
        return Objects.equals(resourceName, that.resourceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceName);
    }

    @Override
    public String toString() {
        return "AllocationDestinationTargetResource{" +
                "resourceName='" + resourceName + '\'' +
                '}';
    }

}
