package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.CampaignForBot;
import ru.yandex.qe.dispenser.domain.bot.BigOrder;
import ru.yandex.qe.dispenser.ws.bot.BotCampaignGroupService;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BotCampaignGroupBodyCreate {
    @Nullable
    private final String key;
    @Nullable
    private final String name;
    @Nullable
    private final Set<Long> bigOrders;
    @Nullable
    private final String botPreOrderIssueKey;
    @Nullable
    private final Set<Long> campaigns;

    @JsonCreator
    public BotCampaignGroupBodyCreate(@Nullable @JsonProperty("key") final String key,
                                      @Nullable @JsonProperty("name") final String name,
                                      @Nullable @JsonProperty("bigOrders") final Set<Long> bigOrders,
                                      @Nullable @JsonProperty("botPreOrderIssueKey") final String botPreOrderIssueKey,
                                      @Nullable @JsonProperty("campaigns") final Set<Long> campaigns) {
        this.key = key;
        this.name = name;
        this.bigOrders = bigOrders;
        this.botPreOrderIssueKey = botPreOrderIssueKey;
        this.campaigns = campaigns;
    }

    @Nullable
    public String getKey() {
        return key;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Set<Long> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public String getBotPreOrderIssueKey() {
        return botPreOrderIssueKey;
    }

    @Nullable
    public Set<Long> getCampaigns() {
        return campaigns;
    }

    public BotCampaignGroup toEntity(final Map<Long, BigOrder> validatedBigOrders, final Map<Long, CampaignForBot> campaigns) {
        if (StringUtils.isEmpty(key)) {
            throw new IllegalArgumentException("Key is required");
        }
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Name is required");
        }
        if (StringUtils.isEmpty(botPreOrderIssueKey)) {
            throw new IllegalArgumentException("Bot preorder issue key is required");
        }
        if (bigOrders == null || bigOrders.isEmpty()) {
            throw new IllegalArgumentException("Big orders are required");
        }
        if (this.campaigns == null || this.campaigns.isEmpty()) {
            throw new IllegalArgumentException("Campaigns are required");
        }

        BotCampaignGroupService.checkCampaigns(campaigns, this.campaigns, Collections.emptySet());
        final List<CampaignForBot> campaignsList = this.campaigns.stream().map(campaigns::get).collect(Collectors.toList());
        BotCampaignGroupService.checkCampaignsUnexpectedBigOrders(campaignsList, bigOrders);

        return new BotCampaignGroup(key, botPreOrderIssueKey, bigOrders.stream().map(validatedBigOrders::get).collect(Collectors.toList()),
                campaignsList, name, false);
    }
}
