package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.BotCampaignGroupUpdate;

public class BotCampaignGroupBodyUpdate {
    @Nullable
    private final String key;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean active;
    @Nullable
    private final Set<Long> bigOrders;
    @Nullable
    private final String botPreOrderIssueKey;
    @Nullable
    private final Set<Long> campaigns;

    @JsonCreator
    public BotCampaignGroupBodyUpdate(@Nullable @JsonProperty("key") final String key,
                                      @Nullable @JsonProperty("name") final String name,
                                      @Nullable @JsonProperty("active") final Boolean active,
                                      @Nullable @JsonProperty("bigOrders") final Set<Long> bigOrders,
                                      @Nullable @JsonProperty("botPreOrderIssueKey") final String botPreOrderIssueKey,
                                      @Nullable @JsonProperty("campaigns") final Set<Long> campaigns) {
        this.key = key;
        this.name = name;
        this.active = active;
        this.bigOrders = bigOrders;
        this.botPreOrderIssueKey = botPreOrderIssueKey;
        this.campaigns = campaigns;
    }

    @Nullable
    public String getKey() {
        return key;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Boolean getActive() {
        return active;
    }

    @Nullable
    public Set<Long> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public String getBotPreOrderIssueKey() {
        return botPreOrderIssueKey;
    }

    @Nullable
    public Set<Long> getCampaigns() {
        return campaigns;
    }

    public BotCampaignGroupUpdate toEntity() {
        return new BotCampaignGroupUpdate(key, name, active, bigOrders, botPreOrderIssueKey, this.campaigns);
    }
}
