package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.dao.bot.service.reserve.configurations.BotConfigurationReserve;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public class BotConfigurationReserveBody {
    @Nullable
    private final Long bigOrderId;
    @Nullable
    private final String locationSegmentKey;
    @Nullable
    private final Long configurationId;
    @Nullable
    private final Long quantity;
    @Nullable
    private final Long storageId;
    @Nullable
    private final Long storageQuantity;

    @JsonCreator
    public BotConfigurationReserveBody(@Nullable @JsonProperty("bigOrderId") final Long bigOrderId,
                                       @Nullable @JsonProperty("locationSegmentKey") final String locationSegmentKey,
                                       @Nullable @JsonProperty("configurationId") final Long configurationId,
                                       @Nullable @JsonProperty("quantity") final Long quantity,
                                       @Nullable @JsonProperty("storageId") final Long storageId,
                                       @Nullable @JsonProperty("storageQuantity") final Long storageQuantity
    ) {
        this.bigOrderId = bigOrderId;
        this.locationSegmentKey = locationSegmentKey;
        this.configurationId = configurationId;
        this.quantity = quantity;
        this.storageId = storageId;
        this.storageQuantity = storageQuantity;
    }

    @Nullable
    public Long getBigOrderId() {
        return bigOrderId;
    }

    @Nullable
    public String getLocationSegmentKey() {
        return locationSegmentKey;
    }

    @Nullable
    public Long getConfigurationId() {
        return configurationId;
    }

    @Nullable
    public Long getQuantity() {
        return quantity;
    }

    @Nullable
    public Long getStorageId() {
        return storageId;
    }

    @Nullable
    public Long getStorageQuantity() {
        return storageQuantity;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return getQuantity() == null
                && getBigOrderId() == null
                && getLocationSegmentKey() == null
                && configurationId == null
                && storageId == null
                && storageQuantity == null;
    }

    @Override
    public String toString() {
        return "BotConfigurationReserveBody{" +
                "bigOrderId=" + bigOrderId +
                ", locationSegmentKey='" + locationSegmentKey + '\'' +
                ", configurationId=" + configurationId +
                ", quantity=" + quantity +
                ", storageId=" + storageId +
                ", storageQuantity=" + storageQuantity +
                '}';
    }

    public BotConfigurationReserve.Builder applyToBuilder(final BotConfigurationReserve.Builder builder, final Hierarchy hierarchy) {
        if (quantity != null) {
            builder.quantity(quantity);
        }
        if (bigOrderId != null) {
            builder.bigOrderId(bigOrderId);
        }
        if (configurationId != null) {
            builder.configurationId(configurationId);
        }
        if (storageId != null) {
            builder.storageId(storageId);
        }
        if (storageQuantity != null) {
            builder.storageQuantity(storageQuantity);
        }
        return builder;
    }
}
