package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.dao.bot.service.reserve.configurations.BotConfigurationReserve;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

import java.util.Objects;

public class BotConfigurationReserveCreate {

    @NotNull
    private final String serviceKey;
    @NotNull
    private final Long bigOrderId;
    @NotNull
    private final String locationSegmentKey;
    @NotNull
    private final Long configurationId;
    @NotNull
    private final Long quantity;
    @Nullable
    private final Long storageId;
    @Nullable
    private final Long storageQuantity;
    @NotNull
    private final Long campaignId;

    @JsonCreator
    public BotConfigurationReserveCreate(@NotNull @JsonProperty("serviceKey") final String serviceKey,
                                         @NotNull @JsonProperty("bigOrderId") final Long bigOrderId,
                                         @NotNull @JsonProperty("locationSegmentKey") final String locationSegmentKey,
                                         @NotNull @JsonProperty("configurationId") final Long configurationId,
                                         @NotNull @JsonProperty("quantity") final Long quantity,
                                         @Nullable @JsonProperty("storageId") final Long storageId,
                                         @Nullable @JsonProperty("storageQuantity") final Long storageQuantity,
                                         @NotNull @JsonProperty("campaignId") final Long campaignId) {
        this.serviceKey = serviceKey;
        this.bigOrderId = bigOrderId;
        this.locationSegmentKey = locationSegmentKey;
        this.configurationId = configurationId;
        this.quantity = quantity;
        this.storageId = storageId;
        this.storageQuantity = storageQuantity;
        this.campaignId = campaignId;
    }

    @NotNull
    public String getServiceKey() {
        return serviceKey;
    }

    @NotNull
    public Long getBigOrderId() {
        return bigOrderId;
    }

    @NotNull
    public String getLocationSegmentKey() {
        return locationSegmentKey;
    }

    @NotNull
    public Long getConfigurationId() {
        return configurationId;
    }

    @NotNull
    public Long getQuantity() {
        return quantity;
    }

    @Nullable
    public Long getStorageId() {
        return storageId;
    }

    @Nullable
    public Long getStorageQuantity() {
        return storageQuantity;
    }

    @NotNull
    public Long getCampaignId() {
        return campaignId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BotConfigurationReserveCreate that = (BotConfigurationReserveCreate) o;
        return serviceKey.equals(that.serviceKey) &&
                bigOrderId.equals(that.bigOrderId) &&
                locationSegmentKey.equals(that.locationSegmentKey) &&
                configurationId.equals(that.configurationId) &&
                quantity.equals(that.quantity) &&
                Objects.equals(storageId, that.storageId) &&
                Objects.equals(storageQuantity, that.storageQuantity) &&
                Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceKey, bigOrderId, locationSegmentKey, configurationId, quantity, storageId, storageQuantity, campaignId);
    }

    public BotConfigurationReserve.Builder toBuilder(final Hierarchy hierarchy) {
        return BotConfigurationReserve.builder()
                .service(hierarchy.getServiceReader().read(getServiceKey()))
                .bigOrderId(getBigOrderId())
                .configurationId(getConfigurationId())
                .quantity(getQuantity())
                .storageId(getStorageId())
                .storageQuantity(getStorageQuantity())
                .campaignId(getCampaignId());
    }

}
