package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.dao.bot.service.reserve.BotServiceReserve;
import ru.yandex.qe.dispenser.domain.dao.segment.SegmentUtils;

public class BotServiceReserveBody {
    @Nullable
    private final DiAmount amount;
    @Nullable
    private final Long bigOrderId;
    @Nullable
    private final Set<String> segmentKeys;

    @JsonCreator
    public BotServiceReserveBody(@Nullable @JsonProperty("amount") final DiAmount amount,
                                 @Nullable @JsonProperty("bigOrderId") final Long bigOrderId,
                                 @Nullable @JsonProperty("segmentKeys") final Set<String> segmentKeys) {
        this.amount = amount;
        this.bigOrderId = bigOrderId;
        this.segmentKeys = segmentKeys;
    }

    @Nullable
    public DiAmount getAmount() {
        return amount;
    }

    @Nullable
    public Long getBigOrderId() {
        return bigOrderId;
    }

    @Nullable
    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    public boolean isEmpty() {
        return getAmount() == null && getBigOrderId() == null && getSegmentKeys() == null;
    }

    public BotServiceReserve applyChangesFor(final BotServiceReserve origin) {
        final Set<Segment> segments = Optional.ofNullable(getSegmentKeys())
                .map(keys -> SegmentUtils.getNonAggregationCompleteSegmentSet(origin.getResource(), keys))
                .orElse(origin.getSegments());

        final long orderId = Optional.ofNullable(getBigOrderId()).orElse(origin.getBigOrderId());
        final long newAmount = Optional.ofNullable(getAmount()).map(origin.getResource().getType().getBaseUnit()::convert).orElse(origin.getAmount());
        return new BotServiceReserve(new BotServiceReserve.Key(origin.getResource(), segments, orderId, origin.getCampaignId()), newAmount);
    }

    @Override
    public String toString() {
        return "BotServiceReserveBody{" +
                "amount=" + amount +
                ", bigOrderId=" + bigOrderId +
                ", segmentKeys='" + segmentKeys + '\'' +
                '}';
    }
}
