package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.bot.service.reserve.BotServiceReserve;
import ru.yandex.qe.dispenser.domain.dao.segment.SegmentUtils;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

import java.util.Objects;
import java.util.Set;

public class BotServiceReserveCreate {

    @NotNull
    private final DiAmount amount;
    @NotNull
    private final Long bigOrderId;
    @NotNull
    private final String resourceKey;
    @NotNull
    private final Set<String> segmentKeys;
    @NotNull
    private final String serviceKey;
    @NotNull
    private final Long campaignId;

    @JsonCreator
    public BotServiceReserveCreate(@NotNull @JsonProperty("amount") final DiAmount amount,
                                   @NotNull @JsonProperty("bigOrderId") final Long bigOrderId,
                                   @NotNull @JsonProperty("resourceKey") final String resourceKey,
                                   @NotNull @JsonProperty("segmentKeys") final Set<String> segmentKeys,
                                   @NotNull @JsonProperty("serviceKey") final String serviceKey,
                                   @NotNull @JsonProperty("campaignId") final Long campaignId) {
        this.amount = amount;
        this.bigOrderId = bigOrderId;
        this.resourceKey = resourceKey;
        this.segmentKeys = segmentKeys;
        this.serviceKey = serviceKey;
        this.campaignId = campaignId;
    }

    @NotNull
    public DiAmount getAmount() {
        return amount;
    }

    @NotNull
    public Long getBigOrderId() {
        return bigOrderId;
    }

    @NotNull
    public String getResourceKey() {
        return resourceKey;
    }

    @NotNull
    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    @NotNull
    public String getServiceKey() {
        return serviceKey;
    }

    @NotNull
    public Long getCampaignId() {
        return campaignId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BotServiceReserveCreate that = (BotServiceReserveCreate) o;
        return Objects.equals(amount, that.amount) &&
                Objects.equals(bigOrderId, that.bigOrderId) &&
                Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(segmentKeys, that.segmentKeys) &&
                Objects.equals(serviceKey, that.serviceKey) &&
                Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, bigOrderId, resourceKey, segmentKeys, serviceKey, campaignId);
    }

    public BotServiceReserve toEntity(@NotNull final Campaign activeCampaign) {
        final Service service = Hierarchy.get().getServiceReader().read(serviceKey);
        final Resource resource = Hierarchy.get().getResourceReader().read(new Resource.Key(resourceKey, service));
        final Long convertedAmount = resource.getType().getBaseUnit().convert(amount);
        final Set<Segment> segments = SegmentUtils.getNonAggregationCompleteSegmentSet(resource, segmentKeys);
        if (activeCampaign.getBigOrders().stream().noneMatch(o -> o.getBigOrderId().equals(bigOrderId))) {
            throw new IllegalArgumentException("Big order '" + bigOrderId + "' is not in the active campaign");
        }
        return new BotServiceReserve(new BotServiceReserve.Key(resource, segments, bigOrderId, activeCampaign.getId()), convertedAmount);
    }

}
