package ru.yandex.qe.dispenser.ws.reqbody;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.bot.BigOrder;

public class CampaignBodyCreate {

    @Nullable
    private final String key;
    @Nullable
    private final String name;
    @Nullable
    private final Set<Long> bigOrders;
    @Nullable
    private final LocalDate startDate;
    @Nullable
    private final Campaign.Type type;

    @JsonCreator
    public CampaignBodyCreate(
            @JsonProperty("key") @Nullable final String key,
            @JsonProperty("name") @Nullable final String name,
            @JsonProperty("bigOrders") @Nullable final Set<Long> bigOrders,
            @JsonProperty("startDate") @Nullable final LocalDate startDate,
            @JsonProperty("type") @Nullable final Campaign.Type type) {
        this.key = key;
        this.name = name;
        this.bigOrders = bigOrders;
        this.startDate = startDate;
        this.type = type;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Set<Long> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public LocalDate getStartDate() {
        return startDate;
    }

    @Nullable
    public String getKey() {
        return key;
    }

    @Nullable
    public Campaign.Type getType() {
        return type;
    }

    @NotNull
    public Campaign toEntity(@NotNull final Map<Long, BigOrder> validatedBigOrders) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Campaign key is required");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Campaign name is required");
        }
        if (bigOrders == null || bigOrders.isEmpty()) {
            throw new IllegalArgumentException("Campaign big orders are required");
        }
        if (startDate == null) {
            throw new IllegalArgumentException("Campaign start date is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("Campaign type is required");
        }
        final List<Campaign.BigOrder> campaignBigOrders = bigOrders.stream().map(validatedBigOrders::get)
                .map(Campaign.BigOrder::new).collect(Collectors.toList());
        return Campaign.builder()
                .setKey(key)
                .setName(name)
                .setStatus(Campaign.Status.CLOSED)
                .setStartDate(startDate)
                .setBigOrders(campaignBigOrders)
                .setRequestCreationDisabled(false)
                .setRequestModificationDisabledForNonManagers(false)
                .setAllowedRequestModificationWhenClosed(false)
                .setAllowedModificationOnMissingAdditionalFields(false)
                .setForcedAllowingRequestStatusChange(false)
                .setSingleProviderRequestModeEnabled(false)
                .setAllowedRequestCreationForProviderAdmin(false)
                .setAllowedRequestCreationForCapacityPlanner(false)
                .setType(type)
                .setRequestModificationDisabled(false)
                .build();
    }

}
