package ru.yandex.qe.dispenser.ws.reqbody;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.CampaignUpdate;
import ru.yandex.qe.dispenser.domain.bot.BigOrder;

public class CampaignBodyUpdate {

    @Nullable
    private final String name;
    @Nullable
    private final Set<Long> bigOrders;
    @Nullable
    private final Campaign.Status status;
    @Nullable
    private final LocalDate startDate;
    @Nullable
    private final Boolean requestCreationDisabled;
    @Nullable
    @Deprecated
    private final Boolean requestModificationDisabledForNonManagers;
    @Nullable
    private final Boolean allowedRequestModificationWhenClosed;
    @Nullable
    private final Boolean allowedModificationOnMissingAdditionalFields;
    @Nullable
    @Deprecated
    protected final Boolean forcedAllowingRequestStatusChange;
    @Nullable
    protected final Boolean singleProviderRequestModeEnabled;
    @Nullable
    @Deprecated
    protected final Boolean allowedRequestCreationForProviderAdmin;
    @Nullable
    @Deprecated
    protected final Boolean allowedRequestCreationForCapacityPlanner;
    @Nullable
    private final Boolean requestModificationDisabled;

    @JsonCreator
    public CampaignBodyUpdate(
            @JsonProperty("name") @Nullable final String name,
            @JsonProperty("bigOrders") @Nullable final Set<Long> bigOrders,
            @JsonProperty("status") @Nullable final Campaign.Status status,
            @JsonProperty("startDate") @Nullable final LocalDate startDate,
            @JsonProperty("requestCreationDisabled") @Nullable final Boolean requestCreationDisabled,
            @JsonProperty("requestModificationDisabledForNonManagers") @Nullable @Deprecated final Boolean requestModificationDisabledForNonManagers,
            @JsonProperty("allowedRequestModificationWhenClosed") @Nullable final Boolean allowedRequestModificationWhenClosed,
            @JsonProperty("allowedModificationOnMissingAdditionalFields") @Nullable final Boolean allowedModificationOnMissingAdditionalFields,
            @JsonProperty("forcedAllowingRequestStatusChange") @Nullable @Deprecated final Boolean forcedAllowingRequestStatusChange,
            @JsonProperty("singleProviderRequestModeEnabled") @Nullable final Boolean singleProviderRequestModeEnabled,
            @JsonProperty("allowedRequestCreationForProviderAdmin") final @Nullable @Deprecated Boolean allowedRequestCreationForProviderAdmin,
            @JsonProperty("allowedRequestCreationForCapacityPlanner") final @Nullable @Deprecated Boolean allowedRequestCreationForCapacityPlanner,
            @JsonProperty("requestModificationDisabled") @Nullable final Boolean requestModificationDisabled) {
        this.name = name;
        this.bigOrders = bigOrders;
        this.status = status;
        this.startDate = startDate;
        this.requestCreationDisabled = requestCreationDisabled;
        this.requestModificationDisabledForNonManagers = requestModificationDisabledForNonManagers;
        this.allowedRequestModificationWhenClosed = allowedRequestModificationWhenClosed;
        this.allowedModificationOnMissingAdditionalFields = allowedModificationOnMissingAdditionalFields;
        this.forcedAllowingRequestStatusChange = forcedAllowingRequestStatusChange;
        this.singleProviderRequestModeEnabled = singleProviderRequestModeEnabled;
        this.allowedRequestCreationForProviderAdmin = allowedRequestCreationForProviderAdmin;
        this.allowedRequestCreationForCapacityPlanner = allowedRequestCreationForCapacityPlanner;
        this.requestModificationDisabled = requestModificationDisabled;
    }

    @Nullable
    public String getName() {
        return name;
    }

    @Nullable
    public Set<Long> getBigOrders() {
        return bigOrders;
    }

    @Nullable
    public Campaign.Status getStatus() {
        return status;
    }

    @Nullable
    public LocalDate getStartDate() {
        return startDate;
    }

    @Nullable
    public Boolean getRequestCreationDisabled() {
        return requestCreationDisabled;
    }

    @Nullable
    @Deprecated
    public Boolean getRequestModificationDisabledForNonManagers() {
        return requestModificationDisabledForNonManagers;
    }

    @Nullable
    public Boolean getAllowedRequestModificationWhenClosed() {
        return allowedRequestModificationWhenClosed;
    }

    @Nullable
    public Boolean getAllowedModificationOnMissingAdditionalFields() {
        return allowedModificationOnMissingAdditionalFields;
    }

    @Nullable
    @Deprecated
    public Boolean getForcedAllowingRequestStatusChange() {
        return forcedAllowingRequestStatusChange;
    }

    @Nullable
    public Boolean getSingleProviderRequestModeEnabled() {
        return singleProviderRequestModeEnabled;
    }

    @Nullable
    @Deprecated
    public Boolean getAllowedRequestCreationForProviderAdmin() {
        return allowedRequestCreationForProviderAdmin;
    }

    @Nullable
    @Deprecated
    public Boolean getAllowedRequestCreationForCapacityPlanner() {
        return allowedRequestCreationForCapacityPlanner;
    }

    @Nullable
    public Boolean getRequestModificationDisabled() {
        return requestModificationDisabled;
    }

    @NotNull
    public CampaignUpdate toEntityUpdate(@NotNull final Map<Long, BigOrder> validatedBigOrders) {
        if (name == null && status == null && startDate == null && bigOrders == null && requestCreationDisabled == null
                && requestModificationDisabledForNonManagers == null
                && allowedRequestModificationWhenClosed == null
                && allowedModificationOnMissingAdditionalFields == null
                && forcedAllowingRequestStatusChange == null
                && singleProviderRequestModeEnabled == null
                && allowedRequestCreationForProviderAdmin == null
                && allowedRequestCreationForCapacityPlanner == null
                && requestModificationDisabled == null) {
            throw new IllegalArgumentException("Update must be non-empty");
        }
        if (name != null && name.isEmpty()) {
            throw new IllegalArgumentException("Non-empty campaign name is required");
        }
        if (bigOrders != null && bigOrders.isEmpty()) {
            throw new IllegalArgumentException("At least one campaign big order is required");
        }
        final Set<Campaign.BigOrder> bigOrdersUpdate = bigOrders != null
                ? bigOrders.stream().map(validatedBigOrders::get)
                .map(Campaign.BigOrder::new).collect(Collectors.toSet())
                : null;

        return CampaignUpdate.builder()
                .setName(name)
                .setStatus(status)
                .setStartDate(startDate)
                .setBigOrders(bigOrdersUpdate == null ? null : new ArrayList<>(bigOrdersUpdate))
                .setRequestCreationDisabled(requestCreationDisabled)
                .setRequestModificationDisabledForNonManagers(requestModificationDisabledForNonManagers)
                .setAllowedRequestModificationWhenClosed(allowedRequestModificationWhenClosed)
                .setAllowedModificationOnMissingAdditionalFields(allowedModificationOnMissingAdditionalFields)
                .setForcedAllowingRequestStatusChange(forcedAllowingRequestStatusChange)
                .setSingleProviderRequestModeEnabled(singleProviderRequestModeEnabled)
                .setAllowedRequestCreationForProviderAdmin(allowedRequestCreationForProviderAdmin)
                .setAllowedRequestCreationForCapacityPlanner(allowedRequestCreationForCapacityPlanner)
                .setRequestModificationDisabled(requestModificationDisabled)
                .build();
    }

}
