package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusRequest {

    @Nullable
    private final List<Long> quotaRequestIds;

    @JsonCreator
    public DeliveryStatusRequest(@JsonProperty("quotaRequestIds") @Nullable List<@Nullable Long> quotaRequestIds) {
        this.quotaRequestIds = quotaRequestIds;
    }

    @Nullable
    public List<@Nullable Long> getQuotaRequestIds() {
        return quotaRequestIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusRequest that = (DeliveryStatusRequest) o;
        return Objects.equals(quotaRequestIds, that.quotaRequestIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestIds);
    }

    @Override
    public String toString() {
        return "DeliveryStatusRequest{" +
                "quotaRequestIds=" + quotaRequestIds +
                '}';
    }

}
