package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusResponse {

    private final List<QuotaRequestDeliveryStatus> quotaRequests;

    @JsonCreator
    public DeliveryStatusResponse(@JsonProperty("quotaRequests") List<QuotaRequestDeliveryStatus> quotaRequests) {
        this.quotaRequests = quotaRequests;
    }

    public List<QuotaRequestDeliveryStatus> getQuotaRequests() {
        return quotaRequests;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusResponse that = (DeliveryStatusResponse) o;
        return Objects.equals(quotaRequests, that.quotaRequests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequests);
    }

    @Override
    public String toString() {
        return "DeliveryStatusResponse{" +
                "quotaRequests=" + quotaRequests +
                '}';
    }

}
