package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.ws.api.model.distribution.ResourceDistributionAlgorithm;

public final class DistributeQuotaBody {

    @Nullable
    private final ResourceDistributionAlgorithm algorithm;
    @Nullable
    private final String serviceKey;
    @Nullable
    private final Long orderId;
    @Nullable
    private final Long campaignId;
    @Nullable
    private final String comment;
    @Nullable
    private final Boolean allocate;
    @Nullable
    private final List<Change> changes;

    @JsonCreator
    public DistributeQuotaBody(
            @Nullable @JsonProperty("algorithm") final ResourceDistributionAlgorithm algorithm,
            @Nullable @JsonProperty("serviceKey") final String serviceKey,
            @Nullable @JsonProperty("orderId") final Long orderId,
            @Nullable @JsonProperty("campaignId") final Long campaignId,
            @Nullable @JsonProperty("comment") final String comment,
            @Nullable @JsonProperty("allocate") final Boolean allocate,
            @Nullable @JsonProperty("changes") final List<Change> changes) {
        this.algorithm = algorithm;
        this.serviceKey = serviceKey;
        this.orderId = orderId;
        this.campaignId = campaignId;
        this.comment = comment;
        this.allocate = allocate;
        this.changes = changes;
    }

    @Nullable
    public ResourceDistributionAlgorithm getAlgorithm() {
        return algorithm;
    }

    @Nullable
    public String getServiceKey() {
        return serviceKey;
    }

    @Nullable
    public Long getOrderId() {
        return orderId;
    }

    @Nullable
    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public String getComment() {
        return comment;
    }

    @Nullable
    public Boolean getAllocate() {
        return allocate;
    }

    @Nullable
    public List<Change> getChanges() {
        return changes;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DistributeQuotaBody that = (DistributeQuotaBody) o;
        return algorithm == that.algorithm &&
                Objects.equals(serviceKey, that.serviceKey) &&
                Objects.equals(orderId, that.orderId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(comment, that.comment) &&
                Objects.equals(allocate, that.allocate) &&
                Objects.equals(changes, that.changes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithm, serviceKey, orderId, campaignId, comment, allocate, changes);
    }

    @Override
    public String toString() {
        return "DistributeQuotaBody{" +
                "algorithm=" + algorithm +
                ", serviceKey='" + serviceKey + '\'' +
                ", orderId=" + orderId +
                ", campaignId=" + campaignId +
                ", comment='" + comment + '\'' +
                ", allocate=" + allocate +
                ", changes=" + changes +
                '}';
    }

    public static final class Change {

        @Nullable
        private final String resourceKey;
        @Nullable
        private final List<String> segmentKeys;
        @Nullable
        private final DiAmount amountReady;

        @JsonCreator
        public Change(
                @Nullable @JsonProperty("resourceKey") final String resourceKey,
                @Nullable @JsonProperty("segmentKeys") final List<String> segmentKeys,
                @Nullable @JsonProperty("amountReady") final DiAmount amountReady) {
            this.resourceKey = resourceKey;
            this.segmentKeys = segmentKeys;
            this.amountReady = amountReady;
        }

        @Nullable
        public String getResourceKey() {
            return resourceKey;
        }

        @Nullable
        public List<String> getSegmentKeys() {
            return segmentKeys;
        }

        @Nullable
        public DiAmount getAmountReady() {
            return amountReady;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Change change = (Change) o;
            return Objects.equals(resourceKey, change.resourceKey) &&
                    Objects.equals(segmentKeys, change.segmentKeys) &&
                    Objects.equals(amountReady, change.amountReady);
        }

        @Override
        public int hashCode() {
            return Objects.hash(resourceKey, segmentKeys, amountReady);
        }

        @Override
        public String toString() {
            return "Change{" +
                    "resourceKey='" + resourceKey + '\'' +
                    ", segmentKeys=" + segmentKeys +
                    ", amountReady=" + amountReady +
                    '}';
        }

    }

}
