package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.Project;

public class EntityOwnershipBody {
    @NotNull
    private Collection<Entity> entities;
    @NotNull
    private Collection<Project> projects;
    private boolean inLeafs;

    public EntityOwnershipBody(@NotNull final Collection<Entity> entities,
                               @NotNull final Collection<Project> projects,
                               final boolean inLeafs) {
        this.entities = entities;
        this.projects = projects;
        this.inLeafs = inLeafs;
    }

    public Collection<Entity> getEntities() {
        return entities;
    }

    public Collection<Project> getProjects() {
        return projects;
    }

    public boolean isInLeafs() {
        return inLeafs;
    }
}
