package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Collections;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiUnit;
import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

public final class MaxValueBody {
    private long maxValue = -1;
    private long ownMaxValue = -1;
    @Nullable
    private DiUnit unit;
    private Set<String> segments = Collections.emptySet();

    public long getMaxValue() {
        return maxValue;
    }

    public long getOwnMaxValue() {
        return ownMaxValue;
    }

    @NotNull
    public DiUnit getUnit() {
        return ValidationUtils.requireNonNull(unit, "Unit required!");
    }

    public void setMaxValue(final long maxValue) {
        this.maxValue = maxValue;
    }

    public void setOwnMaxValue(final long ownMaxValue) {
        this.ownMaxValue = ownMaxValue;
    }

    public void setUnit(@Nullable final DiUnit unit) {
        this.unit = unit;
    }

    public Set<String> getSegments() {
        return segments;
    }

    public void setSegments(final Set<String> segments) {
        this.segments = segments;
    }
}
