package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiPersonGroup;
import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

public final class ProjectBody {
    private static final int MAX_KEY_LEN = 128;
    private static final int MAX_NAME_LEN = 128;
    private static final int MAX_DESCRIPTION_LEN = 512;

    @Nullable
    private String key;
    @Nullable
    private String name;
    @Nullable
    private String description;
    @Nullable
    private Integer abcServiceId;
    @Nullable
    private DiPersonGroup responsibles;
    @Nullable
    private DiPersonGroup members;
    @Nullable
    private String parentProjectKey;
    @Nullable
    private List<String> subprojectKeys;

    @Nullable
    private String mailList;

    @NotNull
    public String getKey() {
        return requireValidKey(key);
    }

    public void setKey(@NotNull final String key) {
        this.key = key;
    }

    @NotNull
    public String getName() {
        return requireValidName(name);
    }

    public void setName(@NotNull final String name) {
        this.name = name;
    }

    @NotNull
    public String getDescription() {
        return requireValidDescription(description);
    }

    public void setDescription(@NotNull final String descrption) {
        this.description = descrption;
    }

    @Nullable
    public Integer getAbcServiceId() {
        return ValidationUtils.validateAbcServiceId(abcServiceId);
    }

    @NotNull
    public DiPersonGroup getResponsibles() {
        return responsibles != null ? responsibles : DiPersonGroup.EMPTY;
    }

    public void setResponsibles(@NotNull final DiPersonGroup responsibles) {
        this.responsibles = responsibles;
    }

    @NotNull
    public DiPersonGroup getMembers() {
        return members != null ? members : DiPersonGroup.EMPTY;
    }

    public void setMembers(@NotNull final DiPersonGroup members) {
        this.members = members;
    }

    @Nullable
    public String getParentProjectKey() {
        return parentProjectKey;
    }

    public void setParentProjectKey(@Nullable final String parentProjectKey) {
        this.parentProjectKey = parentProjectKey;
    }

    @NotNull
    public List<String> getSubprojectKeys() {
        return subprojectKeys != null ? Collections.unmodifiableList(subprojectKeys) : Collections.emptyList();
    }

    public void setSubprojectKeys(@Nullable final List<String> subprojectKeys) {
        this.subprojectKeys = subprojectKeys;
    }

    @NotNull
    private String requireValidKey(@Nullable final String key) {
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("Project key must not be empty!");
        }
        final String trimmedKey = key.trim();
        if (trimmedKey.length() > MAX_KEY_LEN) {
            throw new IllegalArgumentException("Project key must contain no more than '" + MAX_KEY_LEN + "' symbols!");
        }
        return trimmedKey;
    }

    @NotNull
    private String requireValidName(@Nullable final String name) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("Project name must not be empty!");
        }
        final String trimmedName = name.trim();
        if (trimmedName.length() > MAX_NAME_LEN) {
            throw new IllegalArgumentException("Project name must contain no more than '" + MAX_NAME_LEN + "' symbols!");
        }
        return trimmedName;
    }

    @NotNull
    private String requireValidDescription(@Nullable final String description) {
        if (StringUtils.isBlank(description)) {
            throw new IllegalArgumentException("Project description must not be empty!");
        }
        final String trimmedDescription = description.trim();
        if (trimmedDescription.length() > MAX_DESCRIPTION_LEN) {
            throw new IllegalArgumentException("Project description must contain no more than '" + MAX_DESCRIPTION_LEN + "' symbols!");
        }
        return trimmedDescription;
    }

    public void setMailList(@Nullable final String mailList) {
        this.mailList = mailList;
    }

    @Nullable
    public String getMailList() {
        return mailList;
    }
}
