package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiActionType;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.support.Operation;

public final class QuotaChangeBody {
    @NotNull
    private final DiProcessingMode mode;
    @NotNull
    private final Service service;
    @NotNull
    private final Collection<Operation<?>> operations;

    public QuotaChangeBody(@NotNull final DiProcessingMode mode,
                           @NotNull final Service service,
                           @NotNull final Collection<Operation<?>> operations) {
        this.mode = mode;
        this.service = service;
        this.operations = operations;
    }

    @NotNull
    public DiProcessingMode getMode() {
        return mode;
    }

    @NotNull
    public Service getService() {
        return service;
    }

    @NotNull
    public Collection<Operation<?>> getOperations() {
        return operations;
    }

    @NotNull
    public <T> List<T> getActions(@NotNull final Class<T> actionClass, @NotNull final DiActionType... actionTypes) {
        final Stream<Operation<T>> result = operations.stream()
                .filter(o -> actionClass.isInstance(o.getAction()))
                .map(o -> (Operation<T>) o);
        if (actionTypes.length == 0) {
            return result.map(Operation::getAction).collect(Collectors.toList());
        }
        return result.filter(o -> ArrayUtils.contains(actionTypes, o.getType())).map(Operation::getAction).collect(Collectors.toList());
    }
}
