package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestDeliveryAmount {

    private final String resourceKey;
    private final String resourceName;
    private final String providerKey;
    private final String providerName;
    private final List<QuotaRequestDeliverySegment> segments;
    private final long bigOrderId;
    private final String bigOrderName;
    private final DiAmount amount;

    @JsonCreator
    public QuotaRequestDeliveryAmount(@JsonProperty("resourceKey")String resourceKey,
                                      @JsonProperty("resourceName") String resourceName,
                                      @JsonProperty("providerKey") String providerKey,
                                      @JsonProperty("providerName") String providerName,
                                      @JsonProperty("segments") List<QuotaRequestDeliverySegment> segments,
                                      @JsonProperty("bigOrderId") long bigOrderId,
                                      @JsonProperty("bigOrderName") String bigOrderName,
                                      @JsonProperty("amount") DiAmount amount) {
        this.resourceKey = resourceKey;
        this.resourceName = resourceName;
        this.providerKey = providerKey;
        this.providerName = providerName;
        this.segments = segments;
        this.bigOrderId = bigOrderId;
        this.bigOrderName = bigOrderName;
        this.amount = amount;
    }

    public String getResourceKey() {
        return resourceKey;
    }

    public String getResourceName() {
        return resourceName;
    }

    public String getProviderKey() {
        return providerKey;
    }

    public String getProviderName() {
        return providerName;
    }

    public List<QuotaRequestDeliverySegment> getSegments() {
        return segments;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    public String getBigOrderName() {
        return bigOrderName;
    }

    public DiAmount getAmount() {
        return amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestDeliveryAmount that = (QuotaRequestDeliveryAmount) o;
        return bigOrderId == that.bigOrderId &&
                Objects.equals(resourceKey, that.resourceKey) &&
                Objects.equals(resourceName, that.resourceName) &&
                Objects.equals(providerKey, that.providerKey) &&
                Objects.equals(providerName, that.providerName) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(bigOrderName, that.bigOrderName) &&
                Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceKey, resourceName, providerKey, providerName, segments, bigOrderId, bigOrderName,
                amount);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliveryAmount{" +
                "resourceKey='" + resourceKey + '\'' +
                ", resourceName='" + resourceName + '\'' +
                ", providerKey='" + providerKey + '\'' +
                ", providerName='" + providerName + '\'' +
                ", segments=" + segments +
                ", bigOrderId=" + bigOrderId +
                ", bigOrderName='" + bigOrderName + '\'' +
                ", amount=" + amount +
                '}';
    }

}
