package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestDeliveryOperation {

    private final String id;
    private final QuotaRequestDeliveryOperationStatus status;
    @Nullable
    private final String errorMessage;

    @JsonCreator
    public QuotaRequestDeliveryOperation(@JsonProperty("id") String id,
                                         @JsonProperty("status") QuotaRequestDeliveryOperationStatus status,
                                         @JsonProperty("errorMessage") @Nullable String errorMessage) {
        this.id = id;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public String getId() {
        return id;
    }

    public QuotaRequestDeliveryOperationStatus getStatus() {
        return status;
    }

    @Nullable
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestDeliveryOperation that = (QuotaRequestDeliveryOperation) o;
        return Objects.equals(id, that.id) &&
                status == that.status &&
                Objects.equals(errorMessage, that.errorMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, status, errorMessage);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliveryOperation{" +
                "id='" + id + '\'' +
                ", status=" + status +
                ", errorMessage='" + errorMessage + '\'' +
                '}';
    }

}
