package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.Nullable;

public enum QuotaRequestDeliveryOperationStatus {

    UNKNOWN_STATUS_VALUE,
    IN_PROGRESS,
    SUCCESS,
    FAILURE;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @Nullable
    @JsonCreator
    public static QuotaRequestDeliveryOperationStatus fromJsonValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return QuotaRequestDeliveryOperationStatus.valueOf(value);
        } catch (IllegalArgumentException e) {
            return QuotaRequestDeliveryOperationStatus.UNKNOWN_STATUS_VALUE;
        }
    }

}
