package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestDeliverySegment {

    private final String segmentKey;
    private final String segmentName;
    private final String segmentationKey;
    private final String segmentationName;

    @JsonCreator
    public QuotaRequestDeliverySegment(@JsonProperty("segmentKey") String segmentKey,
                                       @JsonProperty("segmentName") String segmentName,
                                       @JsonProperty("segmentationKey") String segmentationKey,
                                       @JsonProperty("segmentationName") String segmentationName) {
        this.segmentKey = segmentKey;
        this.segmentName = segmentName;
        this.segmentationKey = segmentationKey;
        this.segmentationName = segmentationName;
    }

    public String getSegmentKey() {
        return segmentKey;
    }

    public String getSegmentName() {
        return segmentName;
    }

    public String getSegmentationKey() {
        return segmentationKey;
    }

    public String getSegmentationName() {
        return segmentationName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestDeliverySegment that = (QuotaRequestDeliverySegment) o;
        return Objects.equals(segmentKey, that.segmentKey) &&
                Objects.equals(segmentName, that.segmentName) &&
                Objects.equals(segmentationKey, that.segmentationKey) &&
                Objects.equals(segmentationName, that.segmentationName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentKey, segmentName, segmentationKey, segmentationName);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliverySegment{" +
                "segmentKey='" + segmentKey + '\'' +
                ", segmentName='" + segmentName + '\'' +
                ", segmentationKey='" + segmentationKey + '\'' +
                ", segmentationName='" + segmentationName + '\'' +
                '}';
    }

}
