package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestDeliveryStatus {

    private final long requestId;
    private final List<QuotaRequestDeliveryStatusPerDelivery> deliveries;

    @JsonCreator
    public QuotaRequestDeliveryStatus(
            @JsonProperty("requestId") long requestId,
            @JsonProperty("deliveries") List<QuotaRequestDeliveryStatusPerDelivery> deliveries) {
        this.requestId = requestId;
        this.deliveries = deliveries;
    }

    public long getRequestId() {
        return requestId;
    }

    public List<QuotaRequestDeliveryStatusPerDelivery> getDeliveries() {
        return deliveries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestDeliveryStatus that = (QuotaRequestDeliveryStatus) o;
        return requestId == that.requestId &&
                Objects.equals(deliveries, that.deliveries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestId, deliveries);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliveryStatus{" +
                "requestId=" + requestId +
                ", deliveries=" + deliveries +
                '}';
    }

}
