package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestDeliveryStatusPerDelivery {

    private final String id;
    private final boolean pending;
    private final List<QuotaRequestDeliveryAmount> amounts;
    private final List<QuotaRequestDeliveryOperation> operations;

    @JsonCreator
    public QuotaRequestDeliveryStatusPerDelivery(
            @JsonProperty("id") String id,
            @JsonProperty("pending") boolean pending,
            @JsonProperty("amounts") List<QuotaRequestDeliveryAmount> amounts,
            @JsonProperty("operations") List<QuotaRequestDeliveryOperation> operations) {
        this.id = id;
        this.pending = pending;
        this.amounts = amounts;
        this.operations = operations;
    }

    public String getId() {
        return id;
    }

    public boolean isPending() {
        return pending;
    }

    public List<QuotaRequestDeliveryAmount> getAmounts() {
        return amounts;
    }

    public List<QuotaRequestDeliveryOperation> getOperations() {
        return operations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestDeliveryStatusPerDelivery that = (QuotaRequestDeliveryStatusPerDelivery) o;
        return pending == that.pending &&
                Objects.equals(id, that.id) &&
                Objects.equals(amounts, that.amounts) &&
                Objects.equals(operations, that.operations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, pending, amounts, operations);
    }

    @Override
    public String toString() {
        return "QuotaRequestDeliveryStatusPerDelivery{" +
                "id='" + id + '\'' +
                ", pending=" + pending +
                ", amounts=" + amounts +
                ", operations=" + operations +
                '}';
    }

}
