package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class QuotaRequestPendingDeliveryResponse {

    private final List<QuotaRequestPendingDeliveryStatus> deliveries;
    @Nullable
    private final String nextFrom;

    @JsonCreator
    public QuotaRequestPendingDeliveryResponse(
            @JsonProperty("deliveries") List<QuotaRequestPendingDeliveryStatus> deliveries,
            @JsonProperty("nextFrom") @Nullable String nextFrom) {
        this.deliveries = deliveries;
        this.nextFrom = nextFrom;
    }

    public List<QuotaRequestPendingDeliveryStatus> getDeliveries() {
        return deliveries;
    }

    @Nullable
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getNextFrom() {
        return nextFrom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaRequestPendingDeliveryResponse that = (QuotaRequestPendingDeliveryResponse) o;
        return Objects.equals(deliveries, that.deliveries) &&
                Objects.equals(nextFrom, that.nextFrom);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveries, nextFrom);
    }

    @Override
    public String toString() {
        return "QuotaRequestPendingDeliveryResponse{" +
                "deliveries=" + deliveries +
                ", nextFrom='" + nextFrom + '\'' +
                '}';
    }

}
