package ru.yandex.qe.dispenser.ws.reqbody;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiQuotingMode;
import ru.yandex.qe.dispenser.api.v1.DiResourceType;
import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

public final class ResourceBody {
    @Nullable
    private String name;
    @Nullable
    private String description;
    @Nullable
    private DiResourceType type;
    @NotNull
    private DiQuotingMode mode = DiQuotingMode.DEFAULT;
    @Nullable
    private String group;
    @Nullable
    private Integer priority;

    @NotNull
    public String getName() {
        return ValidationUtils.requireNonNull(name, "No name!");
    }

    public void setName(@NotNull final String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(@Nullable final String description) {
        this.description = description;
    }

    public @NotNull DiResourceType getType() {
        return ValidationUtils.requireNonNull(type, "No type!");
    }

    public void setType(final @NotNull DiResourceType type) {
        this.type = type;
    }

    @NotNull
    public DiQuotingMode getQuotingMode() {
        return mode;
    }

    public void setQuotingMode(@NotNull final DiQuotingMode mode) {
        this.mode = mode;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(final String group) {
        this.group = group;
    }

    @Nullable
    public Integer getPriority() {
        return priority;
    }

    public void setPriority(@Nullable final Integer priority) {
        this.priority = priority;
    }
}
