package ru.yandex.qe.dispenser.ws.reqbody;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

@ParametersAreNonnullByDefault
public class SegmentBodyUpdate {
    @Nullable
    private String key;
    @Nullable
    private String name;
    @Nullable
    private String description;
    @Nullable
    private Short priority;

    @NotNull
    public String getKey() {
        return ValidationUtils.requireNonNull(key, "Key is required");
    }

    public void setKey(final String key) {
        this.key = key;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    @Nullable
    public Short getPriority() {
        return priority;
    }

    public void setPriority(final Short priority) {
        this.priority = priority;
    }

    public boolean isEmpty() {
        return name == null && description == null && priority == null;
    }
}
