package ru.yandex.qe.dispenser.ws.reqbody;


import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

@ParametersAreNonnullByDefault
public class SegmentationBody {
    @Nullable
    private String key;
    @Nullable
    private String name;
    @Nullable
    private String description;
    @Nullable
    private Integer priority;

    @NotNull
    public String getKey() {
        return ValidationUtils.requireNonNull(key, "Key is required");
    }

    public void setKey(final String key) {
        this.key = key;
    }

    @NotNull
    public String getName() {
        return ValidationUtils.requireNonNull(name, "Name is required");
    }

    public void setName(final String name) {
        this.name = name;
    }

    @NotNull
    public String getDescription() {
        return ValidationUtils.requireNonNull(description, "Description is required");
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public int getPriority() {
        return ValidationUtils.requireNonNull(priority, "Priority is required");
    }

    public void setPriority(final Integer priority) {
        this.priority = priority;
    }
}
