package ru.yandex.qe.dispenser.ws.reqbody;

import java.util.Arrays;
import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

public final class ServiceBody {
    private String name;
    private Integer abcServiceId;
    private String[] admins;
    private String[] trustees;
    private Integer priority;

    @NotNull
    public String getName() {
        return ValidationUtils.requireNonNull(name, "Service name is required");
    }

    public void setName(@NotNull final String name) {
        this.name = name;
    }

    public Integer getAbcServiceId() {
        return ValidationUtils.validateAbcServiceId(abcServiceId);
    }

    public void setAbcServiceId(final Integer abcServiceId) {
        this.abcServiceId = abcServiceId;
    }

    @Nullable
    public List<String> getAdmins() {
        return admins != null ? Arrays.asList(admins) : null;
    }

    public void setAdmins(final String[] admins) {
        this.admins = admins;
    }

    @Nullable
    public List<String> getTrustees() {
        return trustees != null ? Arrays.asList(trustees) : null;
    }

    public void setTrustees(final String[] trustees) {
        this.trustees = trustees;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(final Integer priority) {
        this.priority = priority;
    }
}
