package ru.yandex.qe.dispenser.ws.reqbody;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.exception.SingleMessageException;
import ru.yandex.qe.dispenser.domain.util.ValidationUtils;

import java.util.List;
import java.util.Set;

public class SetResourceAmountBodyOptional {

    private final List<Item> updates;
    private final UpdateFor updateFor;

    @JsonCreator
    public SetResourceAmountBodyOptional(@Nullable @JsonProperty("updates") final List<Item> updates,
                                         @Nullable @JsonProperty("updateFor") final UpdateFor updateFor) {
        this.updates = ValidationUtils.requireNonNull(updates, "Updates must be non-null");
        this.updateFor = ValidationUtils.requireNonNull(updateFor, "UpdateFor must be non-null");
    }

    public List<Item> getUpdates() {
        return updates;
    }

    public UpdateFor getUpdateFor() {
        return updateFor;
    }

    public static class Item {
        private final Long requestId;
        private final String ticketKey;
        private final List<ChangeBody> changes;
        private final String comment;

        @JsonCreator
        public Item(@Nullable @JsonProperty("requestId") final Long requestId,
                    @Nullable @JsonProperty("ticketKey") final String ticketKey,
                    @Nullable @JsonProperty("changes") final List<ChangeBody> changes,
                    @Nullable @JsonProperty("comment") final String comment) {
            if (requestId == null && ticketKey == null) {
                throw SingleMessageException.illegalArgument("request.id.or.ticket.key.required");
            }
            if (requestId != null && ticketKey != null) {
                throw SingleMessageException.illegalArgument("request.id.and.ticket.key.together");
            }
            this.requestId = requestId;
            this.ticketKey = ticketKey;
            this.changes = changes;
            this.comment = comment;
        }

        public Long getRequestId() {
            return requestId;
        }

        public List<ChangeBody> getChanges() {
            return changes;
        }

        public String getComment() {
            return comment;
        }

        public String getTicketKey() {
            return ticketKey;
        }
    }

    public static class ChangeBody {
        @Nullable
        private final String serviceKey;
        @Nullable
        private final String resourceKey;
        @Nullable
        private final Set<String> segmentKeys;
        @Nullable
        private final Long orderId;

        @JsonCreator
        public ChangeBody(@Nullable @JsonProperty("serviceKey") final String serviceKey,
                          @Nullable @JsonProperty("resourceKey") final String resourceKey,
                          @Nullable @JsonProperty("segmentKeys") final Set<String> segmentKeys,
                          @Nullable @JsonProperty("orderId") final Long orderId) {
            this.serviceKey = serviceKey;
            this.resourceKey = resourceKey;
            this.segmentKeys = segmentKeys;
            this.orderId = orderId;
        }

        @Nullable
        public String getServiceKey() {
            return serviceKey;
        }

        @Nullable
        public String getResourceKey() {
            return resourceKey;
        }

        @Nullable
        public Set<String> getSegmentKeys() {
            return segmentKeys;
        }

        @Nullable
        public Long getOrderId() {
            return orderId;
        }

        @JsonIgnore
        public boolean isEmpty() {
            return serviceKey == null && resourceKey == null && segmentKeys == null && orderId == null;
        }
    }

    public enum UpdateFor {
        READY,
        ALLOCATED,
        BOTH,
    }
}
