package ru.yandex.qe.dispenser.ws.resources_model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.resources_model.QuotaChangeRequestsDeliveryMappings;
import ru.yandex.qe.dispenser.domain.resources_model.QuotaRequestDeliveryContext;
import ru.yandex.qe.dispenser.ws.reqbody.RequestQuotaValidatedBody;

public interface ResourcesModelMapper {

    QuotaRequestDeliveryContext mapNonAllocatingToExternalResources(QuotaChangeRequest request,
                                                                    Collection<QuotaChangeRequest.Change> changes,
                                                                    Service provider,
                                                                    Person author);

    QuotaChangeRequestsDeliveryMappings mapToDestinations(List<QuotaChangeRequest> requests,
                                                          Set<Service> supportedProviders,
                                                          Map<Long, Set<Service>> eligibleProvidersPerRequest);

    QuotaRequestDeliveryContext mapNonAllocatingToExternalResourcesWithAccounts(
            QuotaChangeRequest request, List<QuotaChangeRequest.Change> changesToUpdate, Service service,
            Person performer, RequestQuotaValidatedBody validatedBody);
}
