package ru.yandex.qe.dispenser.ws.resources_model;

import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import ru.yandex.qe.dispenser.domain.Service;

import javax.inject.Inject;
import java.util.Optional;

@Component
public class ResourcesModelMapperManager {
    private final ApplicationContext applicationContext;

    @Inject
    public ResourcesModelMapperManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Optional<ResourcesModelMapper> getMapperForProvider(Service service) {
        String resourcesMappingBeanName = service.getSettings().getResourcesMappingBeanName();
        if (resourcesMappingBeanName == null) {
            return Optional.empty();
        }
        return Optional.of(applicationContext.getBean(resourcesMappingBeanName, ResourcesModelMapper.class));
    }
}
