package ru.yandex.qe.dispenser.ws.staff;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.dao.person.StaffCache;
import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

@DisallowConcurrentExecution
public class StaffCacheRefreshJob implements Job {

    private static final Logger LOG = LoggerFactory.getLogger(StaffCacheRefreshJob.class);

    private StaffCache staffCache;

    @Autowired
    public void setStaffCache(final StaffCache staffCache) {
        this.staffCache = staffCache;
    }

    @Override
    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            staffCache.scheduledRefresh();
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            LOG.error("Staff cache refresh job failed", e);
            throw new JobExecutionException(e);
        }
    }

}
