package ru.yandex.qe.dispenser.ws.staff;

import javax.inject.Inject;

import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.qe.dispenser.solomon.SolomonHolder;

@Configuration
public class StaffSyncConfiguration {

    @NotNull
    private final StaffSyncManager staffSyncManager;
    @NotNull
    private final SolomonHolder solomonHolder;

    @Inject
    public StaffSyncConfiguration(@NotNull final StaffSyncManager staffSyncManager, @NotNull final SolomonHolder solomonHolder) {
        this.staffSyncManager = staffSyncManager;
        this.solomonHolder = solomonHolder;
    }

    @Bean
    @Profile("secondary")
    public StaffSyncTask getStaffSyncTask() {
        return new StaffSyncTask(staffSyncManager, solomonHolder);
    }

}
