package ru.yandex.qe.dispenser.ws.staff;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

@DisallowConcurrentExecution
public class StaffSyncJob implements Job {

    private static final Logger LOG = LoggerFactory.getLogger(StaffSyncJob.class);

    private StaffSyncTask staffSyncTask;

    @Autowired
    public void setStaffSyncTask(final StaffSyncTask staffSyncTask) {
        this.staffSyncTask = staffSyncTask;
    }

    @Override
    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            staffSyncTask.update();
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            LOG.error("Staff sync job failed", e);
            throw new JobExecutionException(e);
        }
    }

}
