package ru.yandex.qe.dispenser.ws.v2;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.api.v1.DiOrder;
import ru.yandex.qe.dispenser.api.v1.DiQuotaLightView;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaUtils;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.ServiceEndpointUtils;
import ru.yandex.qe.dispenser.ws.param.EntitySpecFilterParam;
import ru.yandex.qe.dispenser.ws.param.QuotaGetParams;
import ru.yandex.qe.dispenser.ws.param.ResourceFilterParam;

import static ru.yandex.qe.dispenser.ws.QuotaReadUpdateService.PATH;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.ENTITY_SPEC_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.LEAF_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.MEMBER_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.ORDER_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.PROJECT_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.RESOURCE_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.SEGMENT_PARAM;
import static ru.yandex.qe.dispenser.ws.param.QuotaGetParams.SERVICE_PARAM;

@Path("/v2")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("quota-crud-v2")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class QuotaService extends ServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaService.class);

    @GET
    @Path(PATH + "/old")
    public DiListResponse<DiQuotaLightView> read(@QueryParam(RESOURCE_PARAM) final List<ResourceFilterParam> resourceParams,
                                                 @QueryParam(ENTITY_SPEC_PARAM) final List<EntitySpecFilterParam> entitySpecParams,
                                                 @QueryParam(SEGMENT_PARAM) final Set<String> segmentKeys,
                                                 @QueryParam(SERVICE_PARAM) final Set<Service> services,
                                                 @QueryParam(PROJECT_PARAM) final Set<Project> projects,
                                                 @QueryParam(MEMBER_PARAM) final Set<Person> members,
                                                 @QueryParam(LEAF_PARAM) @DefaultValue("false") final boolean leafProjects,
                                                 @QueryParam(ORDER_PARAM) final DiOrder order) {
        final QuotaGetParams quotaGetParams = new QuotaGetParams(resourceParams, entitySpecParams, segmentKeys, services, projects, members, leafProjects, order);
        ServiceEndpointUtils.memoizeServiceForQuotas(quotaGetParams);
        LOG.debug("Started processing");
        final List<DiQuotaLightView> quotaViews = quotaGetParams.getQuotaStream()
                .map(QuotaUtils::toLightView)
                .collect(Collectors.toList());
        LOG.debug("Returning response");
        return new DiListResponse<>(quotaViews);
    }
}
