package ru.yandex.qe.dispenser.ws.v3;

import java.util.List;

import javax.annotation.Nullable;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.response.DiListPageResponse;
import ru.yandex.qe.dispenser.domain.Entity;
import ru.yandex.qe.dispenser.domain.EntitySpec;
import ru.yandex.qe.dispenser.domain.dao.entity.EntityFilteringParams;
import ru.yandex.qe.dispenser.domain.util.Page;
import ru.yandex.qe.dispenser.domain.util.PageInfo;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.param.EntitySpecFilterParam;
import ru.yandex.qe.dispenser.ws.param.PaginationParam;

import static ru.yandex.qe.dispenser.ws.param.PageParam.LIMIT_PARAM;
import static ru.yandex.qe.dispenser.ws.param.PageParam.PAGE_PARAM;
import static ru.yandex.qe.dispenser.ws.param.PageParam.PAGE_SIZE_PARAM;

@Path("/v3/entities")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("entity-v3")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class EntityService extends ru.yandex.qe.dispenser.ws.EntityService {

    @GET
    @NotNull
    public DiListPageResponse<DiEntity> filterEntities(@QueryParam("entitySpec") @NotNull final List<EntitySpecFilterParam> specFilters,
                                                       @QueryParam("trash") @DefaultValue("false") final boolean trash,
                                                       @QueryParam("from") @Nullable final Long createdFrom,
                                                       @QueryParam("to") @Nullable final Long createdTo,
                                                       @QueryParam(PAGE_PARAM) final Long pageNumberParam,
                                                       @QueryParam(PAGE_SIZE_PARAM) final Long pageSizeParam,
                                                       @QueryParam(LIMIT_PARAM) final Long limitParam,
                                                       @Context final UriInfo uriInfo) {
        final PaginationParam paginationParam = PaginationParam.from(pageNumberParam, pageSizeParam, limitParam, uriInfo);
        if (specFilters.size() != 1) {
            throw new IllegalArgumentException("Single entitySpec should specified");
        }
        final EntitySpec spec = specFilters.iterator().next().get();

        final PageInfo pageInfo = getPageInfo(paginationParam.getPageParam());

        final EntityFilteringParams filteringParams = EntityFilteringParams.builder()
                .trashOnly(trash)
                .createdFrom(createdFrom)
                .createdTo(createdTo)
                .offset((int) pageInfo.getOffset())
                .limit((int) pageInfo.getPageSize())
                .build();

        final Page<Entity> resultPage = entityDao.filterPage(spec, filteringParams);

        return toResponsePage(paginationParam, resultPage, Entity::toView);
    }
}
