package ru.yandex.qe.dispenser.ws.v3;

import java.util.Set;

import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaReader;

public class QuotaFilterParamsImpl implements QuotaReader.QuotaFilterParams {
    private final Set<QuotaSpec> quotaSpecs;
    private final Set<Project> projects;
    private final Set<Segment> segments;

    public QuotaFilterParamsImpl(final Set<QuotaSpec> quotaSpecs, final Set<Project> projects,
                                 final Set<Segment> segments) {
        this.quotaSpecs = quotaSpecs;
        this.projects = projects;
        this.segments = segments;
    }

    @Override
    public Set<QuotaSpec> getQuotaSpecs() {
        return quotaSpecs;
    }

    @Override
    public Set<Project> getProjects() {
        return projects;
    }

    @Override
    public Set<Segment> getSegments() {
        return segments;
    }
}
