<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="utf-8">

    <title>Dispenser</title>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap-theme.min.css">
</head>
<body>

<#setting locale="ru_RU">
<#setting number_format="0.######">

<#assign counter = -1/>

<#macro recurse_macro resource project>
    <#assign counter = counter + 1/>
    <#assign service = resource.service/>

    <div class="panel panel-default">
        <div class="panel-heading" id="heading${counter}" role="tab">
            <h4 class="panel-title">
                <a role="button" class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#collapse${counter}"
                   aria-expanded="true"
                   aria-controls="collapse${counter}">
                    <#assign quota = quotaTable.get(resource, project)/>
                    <div class="row">
                        <div class="col-lg-6">${project.name}</div>
                        <div class="col-lg-6 text-right">${quota.actual} /
                            <#if (!project.isRoot() && isResponsible.test(user, project.parent)) || (project.isRoot() && isServiceAdmin.test(user, service))>
                                <input type="number"
                                       project-key="${project.publicKey}" service-key="${service.key}"
                                       resource-key="${resource.key.publicKey}" quota-spec-key="${quota.spec.key.publicKey}"
                                       base-unit="${resource.type.baseUnit}" prev-value="${quota.max}" value="${quota.max}">
                            <#else>
                                ${quota.max}
                            </#if>
                        </div>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapse${counter}" class="panel-collapse collapse <#if project.isRoot()>in</#if>" role="tabpanel"
             aria-labelledby="heading${counter}">
            <div class="panel-body">
                <div class="update-project">
                    <div class="form-group">
                        <div class="form-group col-lg-3">
                            <div class="input-group">
                                <span class="input-group-addon">Ключ</span>
                                <input type="text" class="form-control project-key"
                                       prev-value="${project.publicKey}" value="${project.publicKey}" disabled>
                            </div>
                        </div>
                        <div class="form-group col-lg-5">
                            <div class="input-group">
                                <span class="input-group-addon">Название</span>
                                <input type="text" class="form-control project-name"
                                       prev-value="${project.name}" value="${project.name}"
                                       <#if !isResponsible.test(user, project)>disabled</#if>>
                            </div>
                        </div>
                        <#if !project.isRoot()>
                            <div class="form-group col-lg-4">
                                <div class="input-group">
                                    <span class="input-group-addon">Ключ родителя</span>
                                    <input type="text" class="form-control parent-key"
                                           prev-value="${project.parent.publicKey}" value="${project.parent.publicKey}"
                                           <#if !isResponsible.test(user, project)>disabled</#if>>
                                </div>
                            </div>
                        </#if>
                    </div>
                    <div class="form-group col-lg-12">
                        <div class="form-group input-group">
                            <span class="input-group-addon">Описание</span>
                            <textarea class="form-control project-description" rows="2"
                                      project-key="${project.publicKey}" prev-value="${project.description}"
                                      <#if !isResponsible.test(user, project)>disabled</#if>>${project.description}</textarea>
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <div class="input-group">
                            <span class="input-group-addon">Ответственные</span>
                            <#assign responsibles = linkedResponsibles.get(project)>
                            <input type="text" class="form-control"
                                   project-key="${project.publicKey}" user-role="responsible"
                                   prev-value="${responsibles?join(', ')}" value="${responsibles?join(', ')}"
                                   <#if !dispenserAdmin && (project.isRoot() || !isResponsible.test(user, project.parent))>disabled</#if>>
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <div class="form-group input-group">
                            <span class="input-group-addon">Участники</span>
                            <#assign members = linkedMemberPersons.get(project)>
                            <textarea class="form-control" rows="1" project-key="${project.publicKey}"
                                      user-role="member-person" prev-value="${members?join(', ')}"
                                      <#if !isResponsible.test(user, project)>disabled</#if>>${members?join(', ')}</textarea>
                        </div>
                    </div>
                    <div class="form-group col-lg-12">
                        <div class="form-group input-group">
                            <span class="input-group-addon">Группы участников</span>
                            <#assign groups = linkedMemberGroups.get(project)>
                            <textarea class="form-control" rows="1" project-key="${project.publicKey}"
                                      user-role="member-group" prev-value="${groups?join(', ')}"
                                      <#if !isResponsible.test(user, project)>disabled</#if>>${groups?join(', ')}</textarea>
                        </div>
                    </div>
                    <#if !project.isRoot() && isResponsible.test(user, project.parent)>
                        <!--div class="form-group col-lg-12">
                          <a class="btn btn-danger pull-right" onclick="removeProject('{project.publicKey}')">Удалить проект</a>
                        </div-->
                    </#if>
                </div>

                <div class="form-group col-lg-12">
                    <#local current_counter = counter/>
                    <div class="panel-group" id="accordion${counter}" role="tablist" aria-multiselectable="true">
                        <#list project.realSubprojects as subproject>
                            <@recurse_macro resource=resource project=subproject/>
                        </#list>
                    </div>
                    <#if isResponsible.test(user, project)>
                        <button class="btn btn-default" onclick="addProject('${project.publicKey}','accordion${current_counter}')">Новый подпроект
                        </button>
                    </#if>
                </div>
            </div>
        </div>
    </div>
</#macro>

<nav class="navbar navbar-default">
    <div class="container-fluid">
        <div class="navbar-header">
            <a class="navbar-brand">Dispenser</a>
        </div>

        <div class="collapse navbar-collapse">
            <ul class="nav navbar-nav">
                <li><a>Админка</a></li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li><a href="https://staff.yandex-team.ru/${user.login}">${user.login}</a></li>
            </ul>
        </div>
    </div>
</nav>

<div class="container">
    <div class="form-group">
        <button class="btn btn-primary" onclick="submit()">Сохранить</button>
        <button class="btn btn-default" onclick="toAdmin()">Отмена</button>
    </div>
    <ul class="nav nav-tabs">
        <#list allResources as resource>
            <li role="presentation" <#if resource?index == 0>class="active"</#if>>
                <a href="#resource${resource?index}" data-toggle="tab">${resource.name}</a>
            </li>
        </#list>
    </ul>
    <br>
    <div class="tab-content">
        <#list allResources as resource>
            <div id="resource${resource?index}" role="tabpanel" class="tab-pane fade <#if resource?index == 0>in active</#if>">
                <div class="panel-group" id="accordion-1" role="tablist" aria-multiselectable="true">
                    <@recurse_macro resource=resource project=root/>
                </div>
            </div>
        </#list>
    </div>
    <div class="form-group">
        <button class="btn btn-primary" onclick="submit()">Сохранить</button>
        <button class="btn btn-default" onclick="toAdmin()">Отмена</button>
    </div>
</div>

<script>
    function submit() {
        $('input[type=number]').each(function () {
            var projectKey = $(this).attr('project-key');
            var serviceKey = $(this).attr('service-key');
            var resourceKey = $(this).attr('resource-key');
            var quotaSpecKey = $(this).attr('quota-spec-key');
            var baseUnit = $(this).attr('base-unit');
            var prevMaxValue = parseInt($(this).attr('prev-value'));
            var nextMaxValue = parseInt($(this).val());
            if (prevMaxValue != nextMaxValue) {
                $.ajax({
                    url: '/api/v1/quotas/' + projectKey + '/' + serviceKey + '/' + resourceKey + '/' + quotaSpecKey,
                    data: JSON.stringify({
                        'maxValue': nextMaxValue,
                        'unit': baseUnit
                    }),
                    type: 'POST',
                    contentType: "application/json; charset=utf-8",
                    async: false,
                    success: function (result) {
                        console.log(result);
                    },
                    error: function (req, textStatus, error) {
                        alert('Ошибка! ' + req.responseText)
                    }
                });
            }
        });
        $('.update-project').each(function () {
            var prevKey = $(this).find('.project-key').attr('prev-value');
            var nextKey = $(this).find('.project-key').val();
            var prevName = $(this).find('.project-name').attr('prev-value');
            var nextName = $(this).find('.project-name').val();
            var prevDescription = $(this).find('.project-description').attr('prev-value');
            var nextDescription = $(this).find('.project-description').val();
            var parentKey = $(this).attr('parent-key');
            var prevResponsibles = $(this).find('[user-role="responsible"]').attr('prev-value');
            var nextResponsibles = $(this).find('[user-role="responsible"]').val();
            var prevMemberPersons = $(this).find('[user-role="member-person"]').attr('prev-value');
            var nextMemberPersons = $(this).find('[user-role="member-person"]').val();
            var prevMemberGroups = $(this).find('[user-role="member-group"]').attr('prev-value');
            var nextMemberGroups = $(this).find('[user-role="member-group"]').val();
            var prevParentKey = $(this).find('.parent-key').attr('prev-value');
            var nextParentKey = $(this).find('.parent-key').val();
            if (prevKey == nextKey && prevName == nextName && prevDescription == nextDescription &&
                prevResponsibles == nextResponsibles && prevMemberPersons == nextMemberPersons &&
                prevMemberGroups == nextMemberGroups && prevParentKey == nextParentKey) {
                return;
            }
            $.ajax({
                url: '/api/v1/projects/' + (parentKey ? parentKey + '/create-subproject' : prevKey),
                data: JSON.stringify({
                    key: nextKey,
                    name: nextName,
                    description: nextDescription,
                    responsibles: {
                        'persons': split(nextResponsibles),
                        'yandexGroups': {
                            'departments': []
                        }
                    },
                    members: {
                        'persons': split(nextMemberPersons),
                        'yandexGroups': {
                            'departments': split(nextMemberGroups)
                        }
                    },
                    parentProjectKey: nextParentKey
                }),
                type: 'POST',
                contentType: "application/json; charset=utf-8",
                async: false,
                success: function (result) {
                    console.log(result);
                },
                error: function (req, textStatus, error) {
                    alert('Ошибка! ' + req.responseText);
                }
            });
        });
        toAdmin();
    }

    function split(s) {
        return s ? $.map(s.split(','), $.trim) : [];
    }

    function toAdmin() {
        location.href = '/api/admin' + location.search;
    }

    var $PROJECT_TEMPLATE = $(".panel").last();
    var COUNTER = $(".panel").size();

    function addProject(parentKey, accordionId) {
        var $newProject = $PROJECT_TEMPLATE.clone();
        $newProject.find(".accordion-toggle").attr("href", '#collapse' + COUNTER).text('Новая папка (2)');
        $newProject.find('.panel-collapse').attr('id', 'collapse' + COUNTER).addClass('in');
        $newProject.find('input').val('');
        $newProject.find('input').attr('value', '');
        $newProject.find('input').attr('prev-value', '');
        $newProject.find('input').removeAttr('disabled');
        $newProject.find('textarea').val('');
        $newProject.find('textarea').attr('prev-value', '');
        $newProject.find('textarea').removeAttr('disabled');
        $newProject.find('button[onclick^=addProject]').remove();
        $newProject.find('a[onclick^=removeProject]').remove();
        $newProject.find('.panel-group').empty();
        $newProject.find('.update-project').attr('parent-key', parentKey);
        $newProject.find('.parent-key').attr('prev-value', parentKey);
        $newProject.find('.parent-key').val(parentKey);
        $newProject.find('.parent-key').attr('disabled', true);
        $('#' + accordionId).append($newProject.fadeIn());
        COUNTER++;
    }

    function removeProject(projectKey) {
        $.ajax({
            url: '/api/v1/projects/' + projectKey,
            type: 'DELETE',
            async: false,
            success: function (result) {
                console.log(result);
            },
            error: function (req, textStatus, error) {
                alert('Ошибка! ' + req.responseText)
            }
        });
        location.href = '/api/admin/edit' + location.search;
    }

</script>

</body>
</html>