<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="utf-8">

    <title>Dispenser</title>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap-theme.min.css">
</head>
<body>

<#setting locale="ru_RU">
<#setting number_format="0.######">

<#assign counter = -1/>

<#macro recurse_macro resource project is_root>
    <#assign counter = counter + 1/>

    <div class="panel panel-default">
        <div class="panel-heading" id="heading${counter}" role="tab">
            <h4 class="panel-title">
                <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse${counter}" aria-expanded="true"
                   aria-controls="collapse${counter}">
                    <#assign quota = quotaTable.get(resource, project)/>
                    <div class="row">
                        <div class="col-lg-6">${project.name}</div>
                        <div class="col-lg-6 text-right">${quota.actual} / ${quota.max}</div>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapse${counter}" class="panel-collapse collapse <#if is_root>in</#if>" role="tabpanel" aria-labelledby="heading${counter}">
            <div class="panel-body">
                <div class="form-group">
                    Ответственные:
                    <#list linkedResponsibles.get(project) as responsible>
                        <a href="https://staff.yandex-team.ru/${responsible.login}">${responsible.login}</a>
                    </#list>
                </div>

                <div class="form-group">
                    Участники:
                    <#list linkedMemberPersons.get(project) as member>
                        <a href="/api/v1/user/${member.login}/projects">${member.login}</a>
                    </#list>
                </div>

                <div class="form-group">
                    Группы участиков:
                    <#list linkedMemberGroups.get(project) as group>
                        <a href="http://staff.yandex-team.ru/departments/${group.url}/">${group.url}</a>
                    </#list>
                </div>

                <div class="form-group">
                    Описание: ${project.description}
                </div>

                <#assign current_counter = counter/>
                <div class="panel-group" id="accordion${counter}" role="tablist" aria-multiselectable="true">
                    <#list project.realSubprojects as subproject>
                        <@recurse_macro resource=resource project=subproject is_root=false/>
                    </#list>
                </div>
            </div>
        </div>
    </div>
</#macro>

<nav class="navbar navbar-default">
    <div class="container-fluid">
        <div class="navbar-header">
            <a class="navbar-brand">Dispenser</a>
        </div>

        <div class="collapse navbar-collapse">
            <ul class="nav navbar-nav">
                <li><a>Админка</a></li>
                <li>
                    <button class="btn btn-default navbar-btn" onclick="toTable()">Сводная таблица</button>
                </li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li>
                    <button class="btn btn-default navbar-btn" onclick="toEdit()">Редактировать</button>
                </li>
                <li><a href="https://staff.yandex-team.ru/${user.login}">${user.login}</a></li>
            </ul>
        </div>
    </div>
</nav>

<div class="container">
    <ul class="nav nav-tabs">
        <#list allResources as resource>
            <li role="presentation" <#if resource?index == 0>class="active"</#if>>
                <a href="#resource${resource?index}" data-toggle="tab">${resource.name}</a>
            </li>
        </#list>
    </ul>
    <br>
    <div class="tab-content">
        <#list allResources as resource>
            <div id="resource${resource?index}" role="tabpanel" class="tab-pane fade <#if resource?index == 0>in active</#if>">
                <div class="panel-group" id="accordion0" role="tablist" aria-multiselectable="true">
                    <@recurse_macro resource=resource project=root is_root=true/>
                </div>
            </div>
        </#list>
    </div>
</div>

<script>
    function toTable() {
        location.href = '/api/table' + location.search;
    }

    function toEdit() {
        location.href = '/api/admin/edit' + location.search;
    }
</script>

</body>
</html>