<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="utf-8">

    <title>Таблица квот</title>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap-theme.min.css">
</head>
<body>

<#macro recurse_macro project depth>
    <#assign subprojects = project.realSubprojects/>
    <tr class="clickable <#if !project.root>collapse out budgets ${project.parent.publicKey} <#if project.parent.root>in</#if></#if>"
        data-toggle="collapse" data-target=".${project.publicKey}">
        <th scope="row"><#list 0 .. depth as t>&nbsp;&nbsp;&nbsp;&nbsp;</#list><#if subprojects?size != 0><a></#if>${project.name}</a></th>
        <#list allServices as service>
            <#list serviceResources.get(service) as resource>
                <#assign q = quotaTable.get(resource, project)>
                <td percent="${q.percent}" class="text-center">
                    <#assign description = "Квота на ${q.resource.name} для проекта ${q.project.name}"/>
                    <#assign solomonUrl = "${solomon.getStatisticsLink(q)}&description=${description}"/>
                    <div class="dropdown">
                        <a class="dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            ${q.percentHtml}% <span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a>Используется ${q.actualAmount.humanize().toString()} из ${q.maxAmount.humanize().toString()}</a></li>
                            <li><a href="${solomonUrl}" target="_blank">История использования</a></li>
                        </ul>
                    </div>
                </td>
            </#list>
        </#list>
    </tr>
    <#list subprojects as subproject>
        <@recurse_macro project=subproject depth=depth + 1/>
    </#list>
</#macro>

<nav class="navbar navbar-default">
    <div class="container-fluid">
        <div class="navbar-header">
            <a class="navbar-brand">Dispenser</a>
        </div>

        <div class="collapse navbar-collapse">
            <ul class="nav navbar-nav">
                <li><a>Сводная таблица</a></li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li><a href="https://staff.yandex-team.ru/${user.login}" target="_blank">${user.login}</a></li>
            </ul>
        </div>
    </div>
</nav>

<table class="table table-bordered fixed">
    <thead>
    <tr>
        <th></th>
        <#list allServices as service>
            <th colspan="${serviceResources.get(service)?size}" class="text-center">${service.name}</th>
        </#list>

    </tr>
    </thead>
    <thead>
    <tr>
        <th class="text-center">Проект</th>
        <#list allServices as service>
            <#list serviceResources.get(service) as resource>
                <th class="text-center">${resource.name}</th>
            </#list>
        </#list>
    </tr>
    </thead>
    <tbody>
    <@recurse_macro project=root depth=0/>
    </tbody>
</table>

<script>
    $(document).ready(function () {
        $("[percent]").addClass(function () {
            var percent = $(this).attr('percent');
            return percent < 90 ? "" : percent < 100 ? "bg-warning" : "bg-danger"
        });
    });
</script>

</body>
</html>