JAVA_LIBRARY(dispenser-ws)

OWNER(g:dispenser)

INCLUDE(${ARCADIA_ROOT}/intranet/dispenser/dispenser-service/server/server.inc)

PEERDIR(
    intranet/dispenser/dispenser-service/client
    intranet/dispenser/dispenser-service/server/application
    intranet/dispenser/dispenser-service/lib/commons-logging
    intranet/dispenser/dispenser-service/lib/commons-bus
    intranet/dispenser/dispenser-service/lib/commons-bus-server
    intranet/dispenser/dispenser-service/lib/commons-json
    intranet/dispenser/dispenser-service/lib/commons-http
    library/java/monlib/metrics
    library/java/monlib/metrics-jvm
    intranet/dispenser/dispenser-service/lib/hitman/hitman-tvm-spring

    contrib/java/org/springframework/security/spring-security-web
    contrib/java/org/springframework/security/spring-security-config
    contrib/java/org/jdom/jdom2
    contrib/java/org/eclipse/jetty/jetty-server
    contrib/java/org/eclipse/jetty/jetty-servlet
    contrib/java/org/eclipse/jetty/jetty-servlets
    contrib/java/org/eclipse/jetty/jetty-annotations
    contrib/java/javax/servlet/javax.servlet-api
    contrib/java/javax/transaction/javax.transaction-api
    contrib/java/org/ow2/asm/asm
    contrib/java/org/ow2/asm/asm-commons
    contrib/java/org/quartz-scheduler/quartz
    contrib/java/org/freemarker/freemarker
    contrib/java/commons-cli/commons-cli
    contrib/java/com/opencsv/opencsv
)

EXCLUDE(
    contrib/java/org/eclipse/jetty/orbit/javax.activation
    contrib/java/org/eclipse/jetty/orbit/org.objectweb.asm
    contrib/java/org/eclipse/jetty/orbit/javax.annotation
    contrib/java/org/eclipse/jetty/orbit/javax.mail.glassfish
    contrib/java/org/eclipse/jetty/orbit/javax.transaction
    contrib/java/javax/annotation/javax.annotation-api
)

JDK_VERSION(17)

JAVAC_FLAGS(
    -parameters
)

KOTLINC_FLAGS(
    -java-parameters
    -opt-in=kotlin.RequiresOptIn
)

WITH_KOTLIN()

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/java **/*.kt)
JAVA_SRCS(SRCDIR src/main/resources **/*)

NO_LINT()
CHECK_JAVA_DEPS(yes)
JAVA_DEPENDENCIES_CONFIGURATION(REQUIRE_DM FORBID_DEFAULT_VERSIONS FORBID_CONFLICT)

END()
