SET(asm.version 9.2)
SET(assertj.version 3.21.0)
SET(bouncycastle.version 1.68)
SET(c3p0.version 0.9.5.4)

SET(commons.cli.version 1.3.1)
SET(commons.collections.version 3.2.2)
SET(commons.dbcp2.version 2.9.0)
SET(commons.fileupload.version 1.4)
SET(commons.io.version 2.11.0)
SET(commons.lang3.version 3.12.0)
SET(commons.lang.version 2.6)
SET(commons.text.version 1.9)

SET(cxf.version 3.5.0)
SET(easystream.version 1.2.15)
SET(ehcache.version 2.10.9.2)
SET(flyway-core.version 8.0.4)
SET(freemarker.version 2.3.31)
SET(guava.version 31.0.1-jre)
SET(hamcrest.version 1.3)
SET(httpasyncclient.version 4.1.4)
SET(httpclient.version 4.5.13)
SET(httpcore.version 4.4.15)
SET(jackson.version 2.13.2.20220328)
SET(janino.version 3.1.6)

SET(javax.activation.version 1.2.2)
SET(jakarta.annotation-api.version 1.3.5)
SET(javax.inject.version 1)
SET(javax.mail.version 1.4.7)
SET(javax.transaction-api.version 1.3)
SET(javax-ws-rs.version 2.1)
SET(jaxws-api.version 2.3.1)
SET(jakarta.xml.ws-api.version 2.3.3)

SET(jcip-annotations.version 1.0)
SET(jdom.version 2.0.6)
SET(jetbrains.annotations.version 22.0.0)
SET(joda-time.version 2.10.13)
SET(jol-core.version 0.15)
SET(jsr305.version 3.0.2)
SET(junit-jupiter.version 5.8.2)
SET(junit.version 4.13.2)
SET(junit-platform.version 1.8.2)
SET(logback.version 1.2.11)
SET(lz4.version 1.8.0)
SET(mockito.version 4.3.1)
SET(objenesis.version 3.2)
SET(opencsv.version 4.5)
SET(org.eclipse.jetty.version 9.4.45.v20220203)
SET(postgresql.version 42.3.2)
SET(quartz.version 2.3.2)
SET(ryantenney.metrics.version 3.1.3)
SET(servlet.api.version 3.1.0)
SET(slf4j.version 1.7.36)
SET(log4j.version 2.17.2)

SET(springockito.version 1.0.9)
SET(spring.retry.version 1.2.5.RELEASE)
SET(spring.security.version 5.6.2)
SET(spring.version 5.3.18)

SET(sqlbuilder.version 3.0.1)
SET(swagger-ui.version 4.1.2)
SET(swagger.version 1.6.4)
SET(zstd-jni.version 1.5.0-4)

SET(kotlinx-coroutines.version 1.6.0)
SET(kotlin-logging-jvm.version 2.1.0)

SET(resilience4j.version 1.7.1)

SET(error_prone_annotations.version 2.10.0)
SET(checker-qual.version 3.18.0)

SET(grpc.version 1.45.1)

SET(netty.version 4.1.75.Final)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/apache/logging/log4j/log4j-bom/${log4j.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-bom/${kotlinx-coroutines.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/netty/netty-bom/${netty.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/fasterxml/jackson/jackson-bom/${jackson.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/google/protobuf/protobuf-bom/${JAVA_PROTO_RUNTIME_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/grpc/grpc-bom/${grpc.version}/ya.dependency_management.inc)
INCLUDE(${KOTLIN_BOM_FILE})

DEPENDENCY_MANAGEMENT(
    contrib/java/org/junit/platform/junit-platform-commons/${junit-platform.version}
    contrib/java/org/junit/platform/junit-platform-engine/${junit-platform.version}
    contrib/java/org/junit/platform/junit-platform-launcher/${junit-platform.version}

    contrib/java/ch/qos/logback/logback-classic/${logback.version}
    contrib/java/ch/qos/logback/logback-core/${logback.version}

    contrib/java/com/fasterxml/jackson/core/jackson-annotations
    contrib/java/com/fasterxml/jackson/core/jackson-core
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-joda
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310
    contrib/java/com/fasterxml/jackson/jaxrs/jackson-jaxrs-json-provider
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin

    contrib/java/com/github/luben/zstd-jni/${zstd-jni.version}

    contrib/java/com/google/code/findbugs/jsr305/${jsr305.version}
    contrib/java/org/flywaydb/flyway-core/${flyway-core.version}
    contrib/java/com/google/guava/guava/${guava.version}
    contrib/java/com/google/errorprone/error_prone_annotations/${error_prone_annotations.version}
    contrib/java/org/checkerframework/checker-qual/${checker-qual.version}

    contrib/java/com/healthmarketscience/sqlbuilder/sqlbuilder/${sqlbuilder.version}
    contrib/java/com/mchange/c3p0/${c3p0.version}

    contrib/java/commons-cli/commons-cli/${commons.cli.version}
    contrib/java/commons-collections/commons-collections/${commons.collections.version}
    contrib/java/commons-fileupload/commons-fileupload/${commons.fileupload.version}
    contrib/java/commons-io/commons-io/${commons.io.version}
    contrib/java/commons-lang/commons-lang/${commons.lang.version}
    contrib/java/org/apache/commons/commons-text/${commons.text.version}

    contrib/java/com/opencsv/opencsv/${opencsv.version}

    contrib/java/com/ryantenney/metrics/metrics-spring/${ryantenney.metrics.version}
    contrib/java/com/sun/activation/jakarta.activation/${javax.activation.version}
    contrib/java/jakarta/activation/jakarta.activation-api/${javax.activation.version}

    contrib/java/jakarta/annotation/jakarta.annotation-api/${jakarta.annotation-api.version}
    contrib/java/javax/inject/javax.inject/${javax.inject.version}
    contrib/java/javax/mail/mail/${javax.mail.version}
    contrib/java/javax/servlet/javax.servlet-api/${servlet.api.version}
    contrib/java/javax/transaction/javax.transaction-api/${javax.transaction-api.version}
    contrib/java/javax/ws/rs/javax.ws.rs-api/${javax-ws-rs.version}
    contrib/java/jakarta/xml/ws/jakarta.xml.ws-api/${jakarta.xml.ws-api.version}

    contrib/java/joda-time/joda-time/${joda-time.version}

    contrib/java/net/jcip/jcip-annotations/${jcip-annotations.version}
    contrib/java/net/sf/ehcache/ehcache/${ehcache.version}

    contrib/java/net/sf/jsignature/io-tools/easystream/${easystream.version}
    contrib/java/org/apache/commons/commons-dbcp2/${commons.dbcp2.version}
    contrib/java/org/apache/commons/commons-lang3/${commons.lang3.version}

    contrib/java/org/apache/cxf/cxf-rt-frontend-jaxrs/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-frontend-jaxws/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-rs-client/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-rs-service-description/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-rs-service-description-swagger/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-transports-http-hc/${cxf.version}
    contrib/java/org/apache/cxf/cxf-rt-transports-local/${cxf.version}

    contrib/java/org/apache/httpcomponents/fluent-hc/${httpclient.version}
    contrib/java/org/apache/httpcomponents/httpasyncclient/${httpasyncclient.version}
    contrib/java/org/apache/httpcomponents/httpclient/${httpclient.version}
    contrib/java/org/apache/httpcomponents/httpclient-cache/${httpclient.version}
    contrib/java/org/apache/httpcomponents/httpcore/${httpcore.version}
    contrib/java/org/apache/httpcomponents/httpcore-nio/${httpcore.version}

    contrib/java/org/assertj/assertj-core/${assertj.version}
    contrib/java/org/bouncycastle/bcpkix-jdk15on/${bouncycastle.version}
    contrib/java/org/codehaus/janino/janino/${janino.version}

    contrib/java/org/eclipse/jetty/jetty-annotations/${org.eclipse.jetty.version}
    contrib/java/org/eclipse/jetty/jetty-server/${org.eclipse.jetty.version}
    contrib/java/org/eclipse/jetty/jetty-servlet/${org.eclipse.jetty.version}
    contrib/java/org/eclipse/jetty/jetty-servlets/${org.eclipse.jetty.version}

    contrib/java/org/freemarker/freemarker/${freemarker.version}
    contrib/java/org/hamcrest/hamcrest-all/${hamcrest.version}
    contrib/java/org/jdom/jdom2/${jdom.version}
    contrib/java/org/jetbrains/annotations/${jetbrains.annotations.version}
    contrib/java/org/junit/jupiter/junit-jupiter/${junit-jupiter.version}
    contrib/java/org/junit/jupiter/junit-jupiter-api/${junit-jupiter.version}
    contrib/java/org/kubek2k/springockito/${springockito.version}
    contrib/java/org/lz4/lz4-java/${lz4.version}
    contrib/java/org/mockito/mockito-core/${mockito.version}
    contrib/java/org/objenesis/objenesis/${objenesis.version}
    contrib/java/org/openjdk/jol/jol-core/${jol-core.version}
    contrib/java/org/ow2/asm/asm/${asm.version}
    contrib/java/org/ow2/asm/asm-commons/${asm.version}
    contrib/java/org/postgresql/postgresql/${postgresql.version}
    contrib/java/org/quartz-scheduler/quartz/${quartz.version}

    contrib/java/org/slf4j/jcl-over-slf4j/${slf4j.version}
    contrib/java/org/slf4j/log4j-over-slf4j/${slf4j.version}
    contrib/java/org/slf4j/slf4j-api/${slf4j.version}

    contrib/java/org/springframework/retry/spring-retry/${spring.retry.version}
    contrib/java/org/springframework/security/spring-security-config/${spring.security.version}
    contrib/java/org/springframework/security/spring-security-core/${spring.security.version}
    contrib/java/org/springframework/security/spring-security-web/${spring.security.version}
    contrib/java/org/springframework/spring-aop/${spring.version}
    contrib/java/org/springframework/spring-aspects/${spring.version}
    contrib/java/org/springframework/spring-beans/${spring.version}
    contrib/java/org/springframework/spring-context/${spring.version}
    contrib/java/org/springframework/spring-context-support/${spring.version}
    contrib/java/org/springframework/spring-core/${spring.version}
    contrib/java/org/springframework/spring-expression/${spring.version}
    contrib/java/org/springframework/spring-jdbc/${spring.version}
    contrib/java/org/springframework/spring-orm/${spring.version}
    contrib/java/org/springframework/spring-test/${spring.version}
    contrib/java/org/springframework/spring-tx/${spring.version}
    contrib/java/org/springframework/spring-web/${spring.version}
    contrib/java/org/springframework/spring-webmvc/${spring.version}

    contrib/java/org/webjars/swagger-ui/${swagger-ui.version}
    contrib/java/io/swagger/swagger-annotations/${swagger.version}
    contrib/java/io/swagger/swagger-core/${swagger.version}
    contrib/java/io/swagger/swagger-jaxrs/${swagger.version}
    contrib/java/io/swagger/swagger-models/${swagger.version}

    contrib/java/io/github/microutils/kotlin-logging-jvm/${kotlin-logging-jvm.version}

    contrib/java/io/github/resilience4j/resilience4j-kotlin/${resilience4j.version}
    contrib/java/io/github/resilience4j/resilience4j-retry/${resilience4j.version}
)

# dependencies that should not be in classpath
EXCLUDE(
    contrib/java/org/springframework/spring-jcl
    contrib/java/commons-logging/commons-logging
    contrib/java/aopalliance/aopalliance
    contrib/java/junit/junit
    contrib/java/com/sun/activation/javax.activation
    contrib/java/javax/activation/javax.activation-api
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/javax/xml/ws/jaxws-api
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/javax/ws/rs/javax.ws.rs-api
    contrib/java/javax/xml/soap/javax.xml.soap-api
    contrib/java/org/apache/geronimo/specs/geronimo-jta_1.1_spec
    contrib/java/org/jdom/jdom
)
